/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.InputSupplier;
import com.xebialabs.deployit.jcr.RuntimeRepositoryException;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.ArtifactEntity;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.SearchQueryBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.jackrabbit.spi.commons.value.QValueValue;

class EntityNodeReader {
    private Session session;
    private Node node;
    private boolean readFully;

    public EntityNodeReader(Session session, Node node, boolean readFully) {
        this.session = session;
        this.node = node;
        this.readFully = readFully;
    }

    public <T extends RepositoryObjectEntity> T getEntity() throws RepositoryException, IOException {
        RepositoryObjectEntity entity = this.instantiateEntity();
        this.copyEntityMetadata(entity);
        this.copyData(entity);
        this.copyValuesIntoEntity(entity);
        return (T)entity;
    }

    private void copyEntityMetadata(RepositoryObjectEntity entity) throws RepositoryException {
        entity.setId(this.node.getProperty("$id").getString());
        entity.setLastModified(this.node.getProperty("$lastModified").getDate());
        if (this.node.hasProperty("$creatingTaskId")) {
            entity.setCreatingTaskId(this.node.getProperty("$creatingTaskId").getString());
        }
    }

    private void copyData(final RepositoryObjectEntity entity) throws RepositoryException, IOException {
        if (entity instanceof ArtifactEntity) {
            ArtifactEntity artifact = (ArtifactEntity)entity;
            ((ArtifactEntity)entity).setFilename(this.node.getProperty("$filename").getString());
            if (this.readFully) {
                artifact.setData((InputSupplier<? extends InputStream>)new InputSupplier<InputStream>(){

                    public InputStream getInput() throws IOException {
                        try {
                            return EntityNodeReader.this.node.getProperty("$data").getBinary().getStream();
                        }
                        catch (RepositoryException exc) {
                            throw new IOException("Cannot read artifact data from " + entity.getId(), exc);
                        }
                    }
                });
            }
        }
    }

    private void copyValuesIntoEntity(RepositoryObjectEntity entity) throws RepositoryException {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)entity.getType());
        if (descriptor == null) {
            Descriptor d2 = DescriptorRegistry.getDescriptor((Type)entity.getType());
            throw new RuntimeException("Cannot find descriptor for " + entity.getType());
        }
        block7: for (PropertyDescriptor pd : descriptor.getPropertyDescriptors()) {
            if (!this.node.hasProperty(pd.getName()) && !pd.isAsContainment()) continue;
            switch (pd.getKind()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: {
                    this.copyPrimitivePropertyFromNode(entity, pd);
                    continue block7;
                }
                case SET_OF_STRING: {
                    this.copySetOfStringsPropertyFromNode(entity, pd);
                    continue block7;
                }
                case CI: {
                    this.copyConfigurationItemPropertyFromNode(entity, pd);
                    continue block7;
                }
                case SET_OF_CI: {
                    this.copySetOfConfigurationItemsPropertyFromNode(entity, pd);
                    continue block7;
                }
                case MAP_STRING_STRING: {
                    this.copyMapPropertyFromNode(entity, pd);
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Cannot convert property " + pd.getName() + " because it is of unsupported kind " + pd.getKind());
        }
    }

    private RepositoryObjectEntity instantiateEntity() throws RepositoryException, IOException {
        Type type = Type.valueOf((String)this.node.getProperty("$configuration.item.type").getString());
        Collection<String> mixinNodeTypeNames = this.getMixinNodeTypeNames();
        if (mixinNodeTypeNames.contains("deployit:artifact")) {
            return new ArtifactEntity(type);
        }
        if (mixinNodeTypeNames.contains("deployit:configurationItem")) {
            return new ConfigurationItemEntity(type);
        }
        throw new IllegalArgumentException("Cannot determine whether JCR node " + JcrPathHelper.getIdFromAbsolutePath(this.node.getPath()) + " is a configuration item");
    }

    protected Collection<String> getMixinNodeTypeNames() throws RepositoryException {
        if (this.nodeIsFrozen()) {
            return this.getMixinNodeTypeNamesFromFrozenNode();
        }
        return this.getMixinNodeTypeNamesFromRegularNode();
    }

    protected Collection<String> getMixinNodeTypeNamesFromFrozenNode() throws RepositoryException {
        Property property = this.node.getProperty("jcr:frozenMixinTypes");
        ArrayList frozenMixinTypes = Lists.newArrayList((Object[])property.getValues());
        return Collections2.transform((Collection)frozenMixinTypes, (Function)new Function<Value, String>(){

            public String apply(Value from) {
                try {
                    return from.getString();
                }
                catch (RepositoryException e) {
                    throw new RuntimeRepositoryException("Cannot convert Value into String", e);
                }
            }
        });
    }

    protected Collection<String> getMixinNodeTypeNamesFromRegularNode() throws RepositoryException {
        ArrayList mixinNodeTypes = Lists.newArrayList((Object[])this.node.getMixinNodeTypes());
        return Collections2.transform((Collection)mixinNodeTypes, (Function)new Function<NodeType, String>(){

            public String apply(NodeType from) {
                return from.getName();
            }
        });
    }

    private void copyMapPropertyFromNode(RepositoryObjectEntity entity, PropertyDescriptor pd) throws RepositoryException {
        HashMap map = Maps.newHashMap();
        for (Value value : this.node.getProperty(pd.getName()).getValues()) {
            String v = value.getString();
            int i = v.indexOf("=");
            map.put(v.substring(0, i), v.substring(i + 1));
        }
        entity.addValue(pd.getName(), map);
    }

    private void copyPrimitivePropertyFromNode(RepositoryObjectEntity entity, PropertyDescriptor pd) throws RepositoryException {
        entity.addValue(pd.getName(), this.node.getProperty(pd.getName()).getString());
    }

    private void copySetOfStringsPropertyFromNode(RepositoryObjectEntity entity, PropertyDescriptor pd) throws RepositoryException {
        HashSet setOfStrings = Sets.newHashSet();
        for (Value each : this.node.getProperty(pd.getName()).getValues()) {
            setOfStrings.add(each.getString());
        }
        entity.addValue(pd.getName(), setOfStrings);
    }

    private void copyConfigurationItemPropertyFromNode(RepositoryObjectEntity entity, PropertyDescriptor pd) throws RepositoryException {
        if (pd.isAsContainment()) {
            entity.addValue(pd.getName(), JcrPathHelper.getIdFromAbsolutePath(this.node.getParent().getPath()));
        } else {
            Value value = this.node.getProperty(pd.getName()).getValue();
            entity.addValue(pd.getName(), this.getReferencedCiId(value));
        }
    }

    private void copySetOfConfigurationItemsPropertyFromNode(RepositoryObjectEntity entity, PropertyDescriptor pd) throws RepositoryException {
        HashSet referencedCiIds = Sets.newHashSet();
        if (pd.isAsContainment()) {
            SearchParameters params = new SearchParameters().setParent(entity.getId()).setType(pd.getReferencedType());
            SearchQueryBuilder builder = new SearchQueryBuilder(params);
            Query query = builder.build(this.session);
            QueryResult queryResult = query.execute();
            NodeIterator iterator = queryResult.getNodes();
            while (iterator.hasNext()) {
                referencedCiIds.add(JcrPathHelper.getIdFromAbsolutePath(iterator.nextNode().getPath()));
            }
        } else {
            for (Value each : this.node.getProperty(pd.getName()).getValues()) {
                referencedCiIds.add(this.getReferencedCiId(each));
            }
        }
        entity.addValue(pd.getName(), referencedCiIds);
    }

    private String getReferencedCiId(Value value) throws RepositoryException {
        String referencedCiUuid = ((QValueValue)value).getQValue().getString();
        Node referencedCi = this.getNodeByUuid(referencedCiUuid);
        return JcrPathHelper.getIdFromAbsolutePath(referencedCi.getPath());
    }

    protected Node getNodeByUuid(String referencedCiUuid) throws RepositoryException {
        try {
            return this.session.getNodeByIdentifier(referencedCiUuid);
        }
        catch (ItemNotFoundException exc) {
            Node frozenNode;
            if (this.nodeIsFrozen() && (frozenNode = this.getFrozenNodeByUuid(referencedCiUuid)) != null) {
                return frozenNode;
            }
            throw exc;
        }
    }

    private Node getFrozenNodeByUuid(String referencedCiUuid) throws RepositoryException {
        QueryManager queryManager = this.session.getWorkspace().getQueryManager();
        ValueFactory valueFactory = this.session.getValueFactory();
        Query query = queryManager.createQuery("SELECT * FROM [{http://www.jcp.org/jcr/nt/1.0}frozenNode] WHERE [jcr:frozenUuid] = $uuid", "JCR-SQL2");
        query.bindValue("uuid", valueFactory.createValue(referencedCiUuid));
        QueryResult result = query.execute();
        NodeIterator resultNodes = result.getNodes();
        if (resultNodes.hasNext()) {
            return resultNodes.nextNode();
        }
        return null;
    }

    private boolean nodeIsFrozen() throws RepositoryException {
        return this.node.isNodeType("{http://www.jcp.org/jcr/nt/1.0}frozenNode");
    }
}

