/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jcr.grouping;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.jcr.grouping.Function;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GroupBy {
    private final List<Function<?>> functions;
    private final Map<String, Map<String, Object>> result = Maps.newHashMap();
    private final Set<String> propertyNames;
    private final Map<String, Field> fields;

    public GroupBy(Collection<String> properties, Function<?> ... functions) {
        this.fields = this.getFields(properties);
        this.propertyNames = Sets.newTreeSet(properties);
        this.functions = functions != null ? Lists.newArrayList((Object[])functions) : Lists.newArrayList();
    }

    private Map<String, Field> getFields(Collection<String> properties) {
        HashMap fields = Maps.newHashMap();
        for (String property : properties) {
            try {
                Field field = DeploymentTaskInfo.class.getDeclaredField(property);
                field.setAccessible(true);
                fields.put(property, field);
            }
            catch (NoSuchFieldException e) {
                new IllegalArgumentException(String.format("Property is %s not defined in %s.", property, DeploymentTaskInfo.class.getName()), e);
            }
        }
        return fields;
    }

    public void process(DeploymentTaskInfo task) {
        String key = this.buildKey(task);
        HashMap newRow = this.result.get(key);
        if (newRow == null) {
            newRow = Maps.newHashMap();
            for (String property : this.propertyNames) {
                try {
                    newRow.put(property, this.fields.get(property).get(task));
                }
                catch (IllegalAccessException e) {
                    new IllegalArgumentException(String.format("Property is %s not defined in %s.", property, DeploymentTaskInfo.class.getName()), e);
                }
            }
            this.result.put(key, newRow);
        }
        this.executeFunctions(task, key, newRow);
    }

    private String buildKey(DeploymentTaskInfo task) {
        StringBuilder keyBuilder = new StringBuilder();
        for (String property : this.propertyNames) {
            try {
                keyBuilder.append(this.fields.get(property).get(task));
                keyBuilder.append("_");
            }
            catch (Exception e) {
                new IllegalArgumentException(String.format("Property is %s not defined in %s.", property, DeploymentTaskInfo.class.getName()), e);
            }
        }
        String key = keyBuilder.toString();
        return key;
    }

    private void executeFunctions(DeploymentTaskInfo task, String key, Map<String, Object> newRow) {
        for (Function<?> function : this.functions) {
            newRow.put(function.getName(), function.invoke(newRow.get(function.getName()), task));
        }
    }

    public Collection<Map<String, Object>> getResult() {
        return this.result.values();
    }
}

