package com.xebialabs.deployit.task.deployment;
import com.xebialabs.deployit.plugin.PojoConverter;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.SecurityCallback;
import com.xebialabs.deployit.security.SecurityTemplate;
import com.xebialabs.deployit.security.UsernameAndPasswordCredentials;
import com.xebialabs.deployit.task.DeploymentTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

import static com.google.common.collect.Lists.newArrayList;

@SuppressWarnings("serial")
public class InitialDeploymentTask extends DeploymentTask {

    private DeltaSpecification specification;
    private transient final PojoConverter pojoConverter;

    public InitialDeploymentTask(final DeltaSpecification specification, final List<? extends DeploymentStep> steps, final RepositoryService repositoryService,
	        final PojoConverter pojoConverter, final PojoConverter.Context... pojoConverterContexts) {
		super(steps, repositoryService, pojoConverterContexts);
        this.specification = specification;
        this.pojoConverter = pojoConverter;
        initFromDeployment(specification.getDeployedApplication());
    }

      @Override
    public void performPreFlightChecks() {
        UsernameAndPasswordCredentials owner = getOwnerCredentials();
		SecurityTemplate.executeAs(owner.getUsername(), owner.getPassword(), new SecurityCallback<Object>() {
            @Override
            public Object doAs() {
                PojoConverter.Context context = pojoConverter.getContext();
                try {
                    repositoryService.checkReferentialIntegrity(determineRepositoryChanges(context));
                } finally {
                    context.destroy();
                }

                return null;
            }
        });
    }

    private ChangeSet determineRepositoryChanges(PojoConverter.Context context) {
        DeployedApplication newDeployment = specification.getDeployedApplication();
        List<RepositoryObjectEntity> roes = newArrayList();
        for (Delta operation : specification.getDeltas()) {
            Deployed deployed = operation.getDeployed();
            roes.add(context.toEntity(deployed));
            newDeployment.addDeployed(deployed);
        }

        RepositoryObjectEntity updatedNewDeploymentEntity = context.toEntity(newDeployment);
        updatedNewDeploymentEntity.setCreatingTaskId(getId());
        roes.add(updatedNewDeploymentEntity);
        ChangeSet changeset = new ChangeSet();
        changeset.setCreateEntities(roes);
        return changeset;
    }

    @Override
	public void doAfterTaskStateChangedToDone() {
		UsernameAndPasswordCredentials owner = getOwnerCredentials();
		SecurityTemplate.executeAs(owner.getUsername(), owner.getPassword(), new SecurityCallback<Object>() {
			@Override
			public Object doAs() {
				PojoConverter.Context context = pojoConverter.getContext();
				try {
                    repositoryService.execute(determineRepositoryChanges(context));
				} finally {
					context.destroy();
				}
				return null;
			}
		});
	}

    @Override
    public DeploymentType getDeploymentType() {
        return DeploymentTask.DeploymentType.INITIAL;
    }

    private Logger logger = LoggerFactory.getLogger(InitialDeploymentTask.class);

}
