package com.xebialabs.deployit.task;

import java.io.Serializable;
import java.util.Calendar;

/*
 * FIXME: Rename to ArchivedTaskStep
 * 
 * Is Serializable because the TaskStep subclass is serialized when the task recovery file is written.
 */
@SuppressWarnings("serial")
public class TaskStepInfo implements Serializable {

    public enum StepState {
		PENDING, EXECUTING, DONE, FAILED, SKIPPED
	}

    private final String description;

	private TaskStep.StepState state;

	private Calendar startDate;

	private Calendar completionDate;

	private String log = "";

	private Calendar lastModificationDate;

    private int failureCount;

    public TaskStepInfo(String description) {
        this.description = description;
        this.lastModificationDate = Calendar.getInstance();
    }

    public TaskStepInfo(String description, StepState state, Calendar startDate, Calendar completionDate, Calendar lastModificationDate, String log, int failureCount) {
        this.description = description;
        this.state = state;
        this.startDate = startDate;
        this.completionDate = completionDate;
        this.lastModificationDate = completionDate;
        if (this.lastModificationDate == null) {
            this.lastModificationDate = Calendar.getInstance();
        }
        this.log = log;
        this.failureCount = failureCount;
    }

    public TaskStep.StepState getState() {
        return state;
    }

    protected void setState(TaskStep.StepState state) {
        this.state = state;
    }

    public Calendar getStartDate() {
        return startDate;
    }

    protected void setStartDate(Calendar startDate) {
        this.startDate = startDate;
    }

    public Calendar getCompletionDate() {
        return completionDate;
    }

    protected void setCompletionDate(Calendar completionDate) {
        this.completionDate = completionDate;
    }

    public String getLog() {
        return log;
    }

    protected void setLog(String log) {
        this.log = log;
    }

    public Calendar getLastModificationDate() {
        return lastModificationDate;
    }

    protected void setLastModificationDate(Calendar lastModificationDate) {
        if (lastModificationDate != null)
            this.lastModificationDate = lastModificationDate;
    }

    public int getFailureCount() {
        return failureCount;
    }

    protected void setFailureCount(int failureCount) {
        this.failureCount = failureCount;
    }

    public String getDescription() {
		return description;
	}
}
