package com.xebialabs.deployit.task;

import java.util.List;

import com.xebialabs.deployit.plugin.PojoConverter;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.repository.RepositoryService;

@SuppressWarnings("serial")
public abstract class DeploymentTask extends Task {

    public enum DeploymentType { INITIAL, UPGRADE, UNDEPLOY, UNKNOWN }

    protected final transient RepositoryService repositoryService;

    protected final transient PojoConverter.Context[] pojoConverterContextsToDestroy;

    private String applicationName;

    private String applicationVersion;

    private String environment;

    public DeploymentTask(final List<? extends DeploymentStep> steps, final RepositoryService repositoryService, final PojoConverter.Context... pojoConverterContextsToDestroy) {
        super(steps);
        this.repositoryService = repositoryService;
        this.pojoConverterContextsToDestroy = pojoConverterContextsToDestroy;
    }

    DeploymentTask(final List<? extends DeploymentStep> steps) {
           super(steps);
           this.repositoryService = null;
           this.pojoConverterContextsToDestroy = null;
    }

	protected DeploymentTask(final List<TaskStep> steps, final State state) {
		this(new StepList(steps, steps.size()), state);
	}

    DeploymentTask(final StepList stepList, State state) {
        super(stepList,state);
        this.repositoryService = null;
        this.pojoConverterContextsToDestroy = null;
    }

    /**
	 * Destroys a task. Cleans up any temporary files needed for execution of the task.
	 */
	public void destroy() {
        super.destroy();
		if(pojoConverterContextsToDestroy == null) {
			return;
		}

		for (PojoConverter.Context each : pojoConverterContextsToDestroy) {
			each.destroy();
		}
	}

    protected void initFromDeployment(final DeployedApplication deployment ) {
        this.setApplicationName(deployment.getVersion().getApplication().getName());
        this.setApplicationVersion(deployment.getVersion().getVersion());
        this.setEnvironment(deployment.getEnvironment().getName());
    }

    private String findLastPathElement(String path) {
        int lastIndexOf = path.lastIndexOf("/");
        if (lastIndexOf > -1 ) {
            return path.substring(lastIndexOf + 1);
        }
        return path;
    }

    public String getApplicationName() {
        return applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationVersion() {
        return applicationVersion;
    }

    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    public String getEnvironment() {
        return environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public abstract DeploymentType getDeploymentType();
}
