package com.xebialabs.deployit.service.replacement;

import com.xebialabs.deployit.plugin.api.udm.Dictionary;
import com.xebialabs.deployit.service.deployment.DictionaryValueException;

import java.util.Collection;
import java.util.Map;

import static com.google.common.collect.Maps.newHashMap;

public class ConsolidatedDictionary {

	private Map<String, String> dict = newHashMap();

	public static ConsolidatedDictionary create(Collection<Dictionary> dicts) {
		ConsolidatedDictionary dictionary = new ConsolidatedDictionary();
		if (dicts != null) {
			for (Dictionary dict : dicts) {
				dictionary.addDictionary(dict);
			}
		}

		return dictionary;
	}

	void addDictionary(Dictionary d) {
		for (String k : d.getEntries().keySet()) {
			if (dict.containsKey(k) && !dict.get(k).equals(d.getEntries().get(k))) {
				throw new IllegalArgumentException("Flattened Dictionary already contains a value for key " + k);
			}
			dict.put(k, d.getEntries().get(k));
		}
	}

	public Map<String,String> getDict() {
		return dict;
	}

	public Object resolve(Object value) throws DictionaryValueException {
		MustachePlaceholderReplacer placeholderReplacer = new MustachePlaceholderReplacer(dict);
		if (value != null && value instanceof String) {
			value = placeholderReplacer.replace((String) value);

		}
		return value;
	}
}
