package com.xebialabs.deployit.service.importer.source;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.server.api.importer.ImportSource;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamSource implements ImportSource {

	private final String fileName;
	private final InputStream stream;

	private FileSource file;

	public InputStreamSource(String fileName, InputStream stream) {
		this.fileName = fileName;
		this.stream = stream;
	}

	@Override
	public File getFile() {
		if (file == null) {
			streamToTempFile();
		}

		return file.getFile();
	}

	private void streamToTempFile() {
		try {
			String fileName = this.fileName;
			int slash = fileName.lastIndexOf('/');
			if (slash != -1 && slash != fileName.length() - 1) {
				fileName = fileName.substring(slash);
			}

			int dot = fileName.lastIndexOf(".");
			String namePart = fileName;
			String extension = ".dar";
			if (dot != -1) {
				namePart = fileName.substring(0, dot);
				extension = fileName.substring(dot);
			}

			final File tempFile = File.createTempFile(namePart, extension);
			FileOutputStream to = new FileOutputStream(tempFile);
			try {
				ByteStreams.copy(stream, to);
			} finally {
				Closeables.closeQuietly(to);
			}
			file = new FileSource(tempFile, true);
		} catch (IOException e) {
			throw new RuntimeIOException(e);
		}
	}

	@Override
	public void cleanUp() {
		if (file != null) {
			file.cleanUp();
		}
	}

	@Override
	public String toString() {
		return this.getClass().getName() + "[" + (file != null ? file : "no file on disk") + "]";
	}
}
