package com.xebialabs.deployit.service.importer;

import de.schlichtherle.truezip.fs.FsDriver;
import de.schlichtherle.truezip.fs.FsScheme;
import de.schlichtherle.truezip.fs.archive.zip.JarDriver;
import de.schlichtherle.truezip.fs.spi.FsDriverService;
import de.schlichtherle.truezip.socket.sl.IOPoolLocator;

import java.util.Map;

/**
 * Maps the Deployit Archive (dar) extension to the TrueZip Jar Driver.
 */
public class DarDriverService extends FsDriverService {
	private final Map<FsScheme, FsDriver> DRIVERS;

	public DarDriverService() {
		DRIVERS = newMap(new Object[][] {
				{ "dar", new JarDriver(IOPoolLocator.SINGLETON) }
		});
	}

	@Override
	public Map<FsScheme, FsDriver> get() {
		return DRIVERS;
	}
}
