package com.xebialabs.deployit.repository;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Metadata;

@SuppressWarnings("serial")
public abstract class RepositoryObjectEntity implements Serializable {

	private String id;

	private Type type;

	private Calendar lastModified;

	private Calendar overrideLastModified;

	private String creatingTaskId;

	private Map<String, Object> values = Maps.newHashMap();

	public RepositoryObjectEntity(Type type) {
		this.type = type;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public void setId(String parentId, String localId) {
		setId(parentId + "/" + localId);
	}

	public void setId(Metadata.ConfigurationItemRoot root, String localId) {
		setId(root.getRootNodeName(), localId);
	}

	public void setId(RepositoryObjectEntity parent, String localId) {
		setId(parent.getId(), localId);
	}

	public Type getType() {
		return type;
	}

	public Calendar getLastModified() {
		return lastModified;
	}

	public void setLastModified(Calendar lastModified) {
		this.lastModified = lastModified;
	}

	public Calendar getOverrideLastModified() {
		return overrideLastModified;
	}

	public void setOverrideLastModified(Calendar overrideLastModified) {
		this.overrideLastModified = overrideLastModified;
	}

	public String getCreatingTaskId() {
		return creatingTaskId;
	}

	public void setCreatingTaskId(String creatingTaskId) {
		this.creatingTaskId = creatingTaskId;
	}

	public Map<String, Object> getValues() {
		return values;
	}

	public void setValues(final Map<String, Object> values) {
		this.values = values;
	}

	public Object getValue(String key) {
		return values.get(key);
	}

	public boolean hasValue(String key) {
		return values.containsKey(key);
	}

	public Object getValue(PropertyDescriptor descriptor) {
		return values.get(descriptor.getName());
	}

	public boolean hasValue(final PropertyDescriptor descriptor) {
		return values.containsKey(descriptor.getName());
	}

	public void addValue(String key, Object value) {
		values.put(key, value);
	}

	public void removeValue(String key) {
		values.remove(key);
	}
}
