package com.xebialabs.deployit.repository;

import java.util.Set;


/**
 */
public class ConfigurationItemValues {
	public static ConfigurationItemValue<Set<String>> DEPLOYABLE_ARTIFACTS = construct("deployableArtifacts");
	public static ConfigurationItemValue<Set<String>> MIDDLEWARE_RESOURCES = construct("middlewareResources");
	public static ConfigurationItemValue<String> ARTIFACT_NAME = construct("name");
	public static ConfigurationItemValue<String> VERSION = construct("version");

	static class ConfigurationItemValue<T> {
		private String key;

		ConfigurationItemValue(String key) {
			this.key = key;
		}
	}

	@SuppressWarnings("unchecked")
    public static <T> T get(ConfigurationItemEntity re, ConfigurationItemValue<T> civ) {
		return (T) re.getValue(civ.key);
	}

	public static <T> void set(ConfigurationItemEntity re, ConfigurationItemValue<T> civ, T value) {
		re.addValue(civ.key, value);
	}

	private static <T> ConfigurationItemValue<T> construct(String key) {
		return new ConfigurationItemValue<T>(key);
	}
}
