package com.xebialabs.deployit.plugin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;

/**
 */
class Imploder {

	public static byte[] implode(File folder) throws IOException {
		final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
		final ZipOutputStream zipper = new ZipOutputStream(outputStream);
		try {
			for (File file : folder.listFiles()) {
				writeEntry(zipper, file, "");
			}
		} finally {
			zipper.close();
		}

		return outputStream.toByteArray();
	}

	private static void writeEntry(final ZipOutputStream zipper, final File file, String path) throws IOException {
		if (file.isDirectory()) {
			zipper.putNextEntry(new ZipEntry(path + file.getName() + "/"));
			writeDirectoryContents(zipper, file, path);
		} else {
			final ZipEntry zipEntry = new ZipEntry(path + file.getName());
			zipper.putNextEntry(zipEntry);
			ByteStreams.copy(Files.newInputStreamSupplier(file), zipper);
			zipper.closeEntry();
		}
	}

	private static void writeDirectoryContents(final ZipOutputStream zipper, final File folder, String path) throws IOException {
		for (File file : folder.listFiles()) {
			writeEntry(zipper, file, path + folder.getName() + "/");
		}
	}
}
