package com.xebialabs.deployit.jcr.grouping;

import static com.google.common.collect.Lists.newArrayList;

import java.util.List;

import com.xebialabs.deployit.task.DeploymentTaskInfo;

public class Duration implements Function<List<Long>> {

	private final String name;

	public Duration(String name) {
		this.name = name;
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<Long> invoke(Object previousValue, DeploymentTaskInfo task) {
		List<Long> durationList = null;
		if (previousValue != null) {
			durationList = (List<Long>) previousValue;
		} else
			durationList = newArrayList();
		durationList.add(task.getDurationInMillis());
		return durationList;
	}

	@Override
	public String getName() {
		return name;
	}
}
