package com.xebialabs.deployit.repository;

import java.util.List;

/**
 * CRUDL for RepositoryEntity and things extending...
 */
public interface RepositoryService {

	<T extends RepositoryObjectEntity> void create(T... entity);

	<T extends RepositoryObjectEntity> T read(String id);

	<T extends RepositoryObjectEntity> T readFully(String id);

	<T extends RepositoryObjectEntity> void update(T... entity);

	void delete(String... id);

    void execute(ChangeSet changeset);

    void checkReferentialIntegrity(ChangeSet changeset) throws ItemInUseException, ItemAlreadyExistsException;

	List<String> list(SearchParameters criteria);

	<T extends RepositoryObjectEntity> List<T> listEntities(SearchParameters parameters);

	boolean checkNodeExists(String id);

}
