package com.xebialabs.deployit.repository;

import java.io.InputStream;

import com.google.common.io.InputSupplier;
import com.xebialabs.deployit.plugin.api.reflect.Type;

@SuppressWarnings("serial")
public class ArtifactEntity extends ConfigurationItemEntity {

	private String filename;

	private InputSupplier<? extends InputStream> data;

	public ArtifactEntity(final Type type) {
		super(type);
	}

	public String getFilename() {
    	return filename;
    }

	public void setFilename(String filename) {
    	this.filename = filename;
    }

	public boolean containsData() {
		return data != null;
	}

	public void clearData() {
		this.data = null;
	}

	public InputSupplier<? extends InputStream> getData() {
		return data;
	}

	public void setData(final InputSupplier<? extends InputStream> data) {
		this.data = data;
	}

}
