/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.ConfigurationItemRoot;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyDescriptor;
import com.xebialabs.deployit.repository.ArchetypeEntity;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;

public abstract class RepositoryObjectEntity
implements Serializable {
    private String id;
    private String configurationItemTypeName;
    private ArchetypeEntity configurationItemArchetype;
    private Calendar lastModified;
    private Calendar overrideLastModified;
    private String creatingTaskId;
    private Map<String, Object> values = Maps.newHashMap();

    public RepositoryObjectEntity(ArchetypeEntity configurationItemArchetype) {
        this(configurationItemArchetype.getConfigurationItemTypeName());
        this.configurationItemArchetype = configurationItemArchetype;
    }

    public RepositoryObjectEntity(String configurationItemTypeName) {
        this.configurationItemTypeName = configurationItemTypeName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setId(String parentId, String localId) {
        this.setId(parentId + "/" + localId);
    }

    public void setId(ConfigurationItemRoot root, String localId) {
        this.setId(root.getRootNodeName(), localId);
    }

    public void setId(RepositoryObjectEntity parent, String localId) {
        this.setId(parent.getId(), localId);
    }

    public String getConfigurationItemTypeName() {
        return this.configurationItemTypeName;
    }

    public ArchetypeEntity getConfigurationItemArchetype() {
        return this.configurationItemArchetype;
    }

    public Calendar getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Calendar lastModified) {
        this.lastModified = lastModified;
    }

    public Calendar getOverrideLastModified() {
        return this.overrideLastModified;
    }

    public void setOverrideLastModified(Calendar overrideLastModified) {
        this.overrideLastModified = overrideLastModified;
    }

    public String getCreatingTaskId() {
        return this.creatingTaskId;
    }

    public void setCreatingTaskId(String creatingTaskId) {
        this.creatingTaskId = creatingTaskId;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public void setValues(Map<String, Object> values) {
        this.values = values;
    }

    public Object getValue(String key) {
        return this.values.get(key);
    }

    public boolean hasValue(String key) {
        return this.values.containsKey(key);
    }

    public Object getValue(ConfigurationItemPropertyDescriptor descriptor) {
        return this.values.get(descriptor.getName());
    }

    public boolean hasValue(ConfigurationItemPropertyDescriptor descriptor) {
        return this.values.containsKey(descriptor.getName());
    }

    public void addValue(String key, Object value) {
        this.values.put(key, value);
    }

    public void removeValue(String key) {
        this.values.remove(key);
    }

    public boolean isArchetype() {
        return false;
    }

    public void setArchetype(ArchetypeEntity archetype) {
        this.configurationItemArchetype = archetype;
    }
}

