/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jetty;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathResourceContentServlet
extends DefaultServlet {
    private static final String FALLBACK_SYSTEM_PROPERTY_NAME = "com.xebialabs.deployit.jetty.ClassPathResourceContentServlet.fallbackDirectory";
    private final String packageName;
    private final boolean fallbackToDevelopmentResources;
    private final String fallbackDirectory;
    private static final Logger logger = LoggerFactory.getLogger(ClassPathResourceContentServlet.class);

    public ClassPathResourceContentServlet(String packageName) {
        assert (packageName != null);
        this.packageName = packageName.replace('.', '/');
        this.fallbackDirectory = System.getProperty(FALLBACK_SYSTEM_PROPERTY_NAME);
        this.fallbackToDevelopmentResources = StringUtils.isNotEmpty((String)this.fallbackDirectory);
        if (logger.isDebugEnabled()) {
            logger.debug("Using " + this.packageName + " as the document root on the classpath (fallbackToDevelopmentResources=" + this.fallbackToDevelopmentResources + ").");
        }
    }

    public Resource getResource(String pathInContext) {
        pathInContext = pathInContext.replace("-${project.version}-${deployit.edition}-edition", "");
        String resourcePath = "/" + this.packageName + pathInContext;
        if (logger.isDebugEnabled()) {
            logger.debug("Requested resource " + resourcePath + " to load");
        }
        URL url = ((Object)((Object)this)).getClass().getResource(resourcePath);
        try {
            Resource r = Resource.newResource((URL)url);
            if ((r == null || !r.exists()) && this.fallbackToDevelopmentResources) {
                String fallbackUrl = "file:" + this.fallbackDirectory + pathInContext;
                if (logger.isInfoEnabled()) {
                    logger.info("Cannot find " + resourcePath + " in classpath, falling back to URL " + fallbackUrl);
                }
                r = Resource.newResource((String)fallbackUrl);
            }
            if (r == null || !r.exists()) {
                if (resourcePath.endsWith(".gz")) {
                    logger.debug("Cannot find " + resourcePath + " in classpath");
                } else {
                    logger.error("Cannot find " + resourcePath + " in classpath");
                }
            }
            return r;
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }
}

