/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.task.TaskExecutionContext;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskStep
implements Serializable {
    private final Step implementation;
    private final String description;
    private StepState state;
    private Calendar startDate;
    private Calendar completionDate;
    private String log = "";
    private Calendar lastModificationDate;
    private static final Logger logger = LoggerFactory.getLogger(TaskStep.class);

    public TaskStep(Step step) {
        this.implementation = step;
        this.description = step.getDescription();
        this.setState(StepState.PENDING);
    }

    TaskStep(String description, StepState state) {
        this.description = description;
        this.setState(state);
        this.implementation = null;
    }

    public void execute(TaskExecutionContext taskContext) {
        if (this.state != StepState.PENDING && this.state != StepState.FAILED) {
            logger.debug("Will not execute: {} with description: {} because it has state: {}", new Object[]{this.implementation, this.implementation.getDescription(), this.state});
            return;
        }
        this.setStartDate();
        this.setState(StepState.EXECUTING);
        this.clearLog();
        logger.info("Executing: {} with description: {}", (Object)this.implementation, (Object)this.implementation.getDescription());
        TaskStepExecutionContext context = new TaskStepExecutionContext(taskContext);
        try {
            boolean result = this.implementation.execute((StepExecutionContext)context);
            this.setState(result ? StepState.DONE : StepState.FAILED);
        }
        catch (Exception exc) {
            context.logError("Step failed", exc);
            this.setState(StepState.FAILED);
        }
        catch (Throwable t) {
            context.logError("Step failed badly, aborting!", t);
            Thread.currentThread().interrupt();
            this.setState(StepState.FAILED);
        }
        this.setCompletionDate();
    }

    public Step getImplementation() {
        return this.implementation;
    }

    public String getDescription() {
        return this.description;
    }

    public StepState getState() {
        return this.state;
    }

    public boolean isFailed() {
        return this.state == StepState.FAILED;
    }

    public boolean isSkipped() {
        return this.state == StepState.SKIPPED;
    }

    public boolean canSkip() {
        return this.state == StepState.PENDING || this.state == StepState.FAILED;
    }

    public void skip() {
        this.setState(StepState.SKIPPED);
    }

    public void unskip() {
        this.setState(StepState.PENDING);
    }

    void setState(StepState state) {
        this.state = state;
        this.setLastModificationDate();
    }

    public Calendar getStartDate() {
        return this.startDate;
    }

    private void setStartDate() {
        this.startDate = Calendar.getInstance();
        this.setLastModificationDate();
    }

    void setStartDate(Calendar startDate) {
        this.startDate = startDate;
    }

    public Calendar getCompletionDate() {
        return this.completionDate;
    }

    private void setCompletionDate() {
        this.completionDate = Calendar.getInstance();
        this.setLastModificationDate();
    }

    void setCompletionDate(Calendar completionDate) {
        this.completionDate = completionDate;
    }

    public String getLog() {
        return this.log;
    }

    public void clearLog() {
        this.log = "";
    }

    void setLog(String log) {
        this.log = log;
    }

    public Calendar getLastModificationDate() {
        return this.lastModificationDate;
    }

    protected void setLastModificationDate() {
        this.lastModificationDate = Calendar.getInstance();
    }

    class TaskStepExecutionContext
    implements StepExecutionContext {
        private TaskExecutionContext taskContext;
        private Logger stepLogger;

        TaskStepExecutionContext(TaskExecutionContext taskContext) {
            this.taskContext = taskContext;
            this.stepLogger = LoggerFactory.getLogger(TaskStep.this.implementation.getClass());
        }

        public void logOutput(String output) {
            this.stepLogger.info(output);
            TaskStep.this.log = TaskStep.this.log + (output + "\n");
            TaskStep.this.setLastModificationDate();
        }

        public void logError(String error) {
            this.stepLogger.error(error);
            TaskStep.this.log = TaskStep.this.log + (error + "\n");
            TaskStep.this.setLastModificationDate();
        }

        public void logError(String error, Throwable t) {
            this.stepLogger.error(error, t);
            TaskStep.this.log = TaskStep.this.log + (error + "\n");
            StringWriter stringWriter = new StringWriter();
            t.printStackTrace(new PrintWriter(stringWriter));
            TaskStep.this.log = TaskStep.this.log + (stringWriter.toString() + "\n");
            TaskStep.this.setLastModificationDate();
        }

        public Object getAttribute(String name) {
            Object object = this.taskContext.getAttribute(name);
            this.stepLogger.debug("Getting value of attribute {}: {}", (Object)name, object);
            return object;
        }

        public void setAttribute(String name, Object object) {
            this.stepLogger.debug("Setting value of attribute {}: {}", (Object)name, object);
            this.taskContext.setAttribute(name, object);
        }
    }

    public static enum StepState {
        PENDING,
        EXECUTING,
        DONE,
        FAILED,
        SKIPPED;

    }
}

