/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer;

import com.xebialabs.deployit.ci.artifact.Folder;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.repository.ArtifactEntity;
import com.xebialabs.deployit.service.importer.DeployableArtifactImporter;
import com.xebialabs.deployit.service.importer.ImporterException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleFileTypeArtifactImporter
extends DeployableArtifactImporter {
    private static final Logger logger = LoggerFactory.getLogger(SingleFileTypeArtifactImporter.class);

    @Override
    public boolean canHandle(ConfigurationItemDescriptor typeDescriptor) {
        return !typeDescriptor.getSuperClasses().contains(Folder.class.getName());
    }

    @Override
    public void importArtifact(ArtifactEntity artifact, File artifactFile, ConfigurationItemDescriptor typeDescriptor) {
        this.doImport(artifact, artifactFile);
        if (typeDescriptor.getPropertyDescriptor("placeholders") != null) {
            this.parsePlaceholders(artifact, artifactFile);
        }
    }

    @Override
    public void doImport(ArtifactEntity artifact, File artifactFile) {
        byte[] artifactAsBytes;
        try {
            artifactAsBytes = FileUtils.readFileToByteArray((File)artifactFile);
        }
        catch (IOException e) {
            throw new ImporterException(e, "Unable to read " + artifactFile, new Object[0]);
        }
        artifact.setData(new ByteArrayInputStream(artifactAsBytes));
    }
}

