/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ChangeResolution;
import com.xebialabs.deployit.MappingInfo;
import com.xebialabs.deployit.Mappings;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.RunBook;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.DeploymentPackage;
import com.xebialabs.deployit.ci.Environment;
import com.xebialabs.deployit.ci.MiddlewareResource;
import com.xebialabs.deployit.ci.artifact.DeployableArtifact;
import com.xebialabs.deployit.ci.mapping.Mapping;
import com.xebialabs.deployit.exception.DeployitException;
import com.xebialabs.deployit.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.plugin.PluginLoader;
import com.xebialabs.deployit.plugin.PojoConverter;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.deployment.InitialDeploymentTask;
import com.xebialabs.deployit.task.deployment.UndeploymentTask;
import com.xebialabs.deployit.task.deployment.UpgradeDeploymentTask;
import com.xebialabs.deployit.translation.DefaultChange;
import com.xebialabs.deployit.translation.MappingGenerator;
import com.xebialabs.deployit.translation.SimpleChangePlan;
import com.xebialabs.deployit.typedescriptor.ConfigurationItemDescriptorRepositoryHolder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeploymentService {
    @Autowired
    private PojoConverter pojoConverter;
    @Autowired
    private MappingGenerator defaultMappingGenerator;
    @Autowired
    private PluginLoader pluginLoader;
    @Autowired
    private RepositoryService repositoryService;
    private static final Logger logger = LoggerFactory.getLogger(DeploymentService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mappings generatePartialDefaultMappings(ConfigurationItemEntity source, List<ConfigurationItemEntity> sources, ConfigurationItemEntity target, String mappingType) {
        PojoConverter.Context pojoConverterContext = this.pojoConverter.getContext();
        try {
            Environment env;
            DeploymentPackage deploymentPackage = (DeploymentPackage)pojoConverterContext.toPojo(source);
            DeploymentPackage dummyDeploymentPackage = new DeploymentPackage();
            dummyDeploymentPackage.setApplication(deploymentPackage.getApplication());
            for (ConfigurationItemEntity each : sources) {
                Object pojo = pojoConverterContext.toPojo(each);
                if (pojo instanceof DeployableArtifact) {
                    dummyDeploymentPackage.addDeployableArtifact((DeployableArtifact)pojo);
                    continue;
                }
                if (pojo instanceof MiddlewareResource) {
                    dummyDeploymentPackage.addMiddlewareResource((MiddlewareResource)pojo);
                    continue;
                }
                throw new Checks.IncorrectArgumentException("{} is not a DeployableArtifact or a MiddlewareResource.", pojo);
            }
            String targetType = target.getConfigurationItemTypeName();
            ConfigurationItemDescriptor targetDescriptor = ConfigurationItemDescriptorRepositoryHolder.getDescriptor(targetType);
            if (this.isAssignable(targetDescriptor, Environment.class)) {
                env = (Environment)pojoConverterContext.toPojo(target);
            } else {
                env = new Environment();
                Object targetPojo = pojoConverterContext.toPojo(target);
                env.addMember((Serializable)targetPojo);
            }
            Mappings mappings = this.convertMappings(this.defaultMappingGenerator.generateMappingsForInitialDeployment(dummyDeploymentPackage, env, mappingType));
            return mappings;
        }
        finally {
            pojoConverterContext.destroy();
        }
    }

    private boolean isAssignable(ConfigurationItemDescriptor desc, Class<?> clazz) {
        return clazz.isAssignableFrom(desc.getTypeClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mappings generateDefaultMappings(ConfigurationItemEntity source, ConfigurationItemEntity target) {
        PojoConverter.Context pojoConverterContext = this.pojoConverter.getContext();
        try {
            DeploymentPackage pkg = (DeploymentPackage)pojoConverterContext.toPojo(source);
            Environment env = (Environment)pojoConverterContext.toPojo(target);
            List<MappingInfo> mappings = this.defaultMappingGenerator.generateMappingsForInitialDeployment(pkg, env, null);
            Mappings mappings2 = this.convertMappings(mappings);
            return mappings2;
        }
        finally {
            pojoConverterContext.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mappings generateMappingsForUpgradeDeployment(ConfigurationItemEntity newSourceEntity, ConfigurationItemEntity deploymentEntity) {
        PojoConverter.Context pojoConverterContext = this.pojoConverter.getContext();
        try {
            Deployment deployment = (Deployment)pojoConverterContext.toPojo(deploymentEntity);
            DeploymentPackage newPackage = (DeploymentPackage)pojoConverterContext.toPojo(newSourceEntity);
            List<MappingInfo> generatedMappingsForUpgrade = this.defaultMappingGenerator.generateMappingsForUpgradeDeployment(deployment, newPackage);
            Mappings mappings = this.convertMappings(generatedMappingsForUpgrade);
            return mappings;
        }
        finally {
            pojoConverterContext.destroy();
        }
    }

    private Mappings convertMappings(Collection<MappingInfo> mappingsInfo) {
        Mappings mappings = new Mappings();
        ArrayList validMappings = Lists.newArrayList();
        ArrayList invalidMappings = Lists.newArrayList();
        for (MappingInfo mappingInfo : mappingsInfo) {
            ConfigurationItemEntity mappingEntity = this.pojoConverter.toEntity(mappingInfo.getMapping());
            if (mappingInfo.getValidMapping().booleanValue()) {
                validMappings.add(mappingEntity);
                continue;
            }
            invalidMappings.add(mappingEntity);
        }
        mappings.setValidMappings(validMappings);
        mappings.setInvalidMappings(invalidMappings);
        return mappings;
    }

    public Task prepareInitialDeployment(ConfigurationItemEntity sourceEntity, ConfigurationItemEntity targetEntity, Collection<ConfigurationItemEntity> mappingEntities) {
        PojoConverter.Context pojoConverterContext = this.pojoConverter.getContext();
        DeploymentPackage pkg = (DeploymentPackage)pojoConverterContext.toPojo(sourceEntity);
        Environment env = (Environment)pojoConverterContext.toPojo(targetEntity);
        Deployment newDeployment = new Deployment(pkg, env);
        newDeployment.setLabel(DeploymentService.generateDeploymentLabel(pkg, env));
        for (ConfigurationItemEntity each : mappingEntities) {
            String sourceId = (String)each.getValue("source");
            String generatedId = (String)each.getValue("target") + "/" + sourceId.substring(sourceId.lastIndexOf("/") + 1);
            each.setId(generatedId);
            newDeployment.addMapping((Mapping)pojoConverterContext.toPojo(each));
        }
        List<Step> steps = this.getSteps(DefaultChange.with(null, newDeployment));
        InitialDeploymentTask initialDeploymentTask = new InitialDeploymentTask(sourceEntity, targetEntity, mappingEntities, steps, this.repositoryService, this.pojoConverter, pojoConverterContext);
        initialDeploymentTask.setLabel(String.format(Task.DEPLOYMENT_TASK_LABEL_FORMAT, pkg.getLabel(), pkg.getVersion(), env));
        return initialDeploymentTask;
    }

    public static String generateDeploymentLabel(DeploymentPackage pkg, Environment env) {
        String applicationId = pkg.getApplication().getLabel();
        String applicationName = applicationId.substring(applicationId.lastIndexOf("/") + 1);
        return env.getLabel() + "/" + applicationName;
    }

    public Task prepareUpgradeDeployment(ConfigurationItemEntity newSourceEntity, ConfigurationItemEntity existingDeploymentEntity, Collection<ConfigurationItemEntity> mappingEntities) {
        PojoConverter.Context repositoryContext = this.pojoConverter.getContext();
        DeploymentPackage newPkg = (DeploymentPackage)repositoryContext.toPojo(newSourceEntity);
        Deployment existingDeployment = (Deployment)repositoryContext.toPojo(existingDeploymentEntity);
        Environment env = existingDeployment.getTarget();
        Deployment newDeployment = new Deployment(newPkg, env);
        newDeployment.setLabel(existingDeployment.getLabel());
        for (ConfigurationItemEntity each : mappingEntities) {
            String sourceId = (String)each.getValue("source");
            String generatedId = (String)each.getValue("target") + "/" + sourceId.substring(sourceId.lastIndexOf("/") + 1);
            each.setId(generatedId);
        }
        PojoConverter.Context mappingsContext = this.pojoConverter.getContext();
        Collection mappings = mappingsContext.toPojo(mappingEntities);
        for (Mapping each : mappings) {
            newDeployment.addMapping(each);
        }
        ConfigurationItemEntity newDeploymentEntity = this.pojoConverter.toEntity(newDeployment);
        List<Step> steps = this.getSteps(DefaultChange.with(existingDeployment, newDeployment));
        UpgradeDeploymentTask upgradeDeploymentTask = new UpgradeDeploymentTask(mappingEntities, newDeploymentEntity, steps, this.repositoryService, this.pojoConverter, repositoryContext, mappingsContext);
        upgradeDeploymentTask.setLabel(String.format(Task.UPGRADE_TASK_LABEL_FORMAT, newPkg.getLabel(), existingDeployment.getSource().getVersion(), newPkg.getVersion(), env));
        return upgradeDeploymentTask;
    }

    protected List<Step> getSteps(DefaultChange<Deployment> change) {
        SimpleChangePlan plan = new SimpleChangePlan(change);
        Collection<RunBook> runBookCollection = this.pluginLoader.getRunBooks();
        try {
            for (RunBook runBook : runBookCollection) {
                Collection resolutions = runBook.resolve((ChangePlan)plan);
                for (ChangeResolution each : resolutions) {
                    plan.addSteps(each.getSteps());
                }
            }
        }
        catch (ResolutionException re) {
            logger.error("Failed to resolve all the mappings into steps.", (Throwable)re);
            throw new DeploymentException(re.getMessage());
        }
        return plan.getSteps();
    }

    public Task prepareUndeployment(ConfigurationItemEntity source) {
        PojoConverter.Context pojoConverterContext = this.pojoConverter.getContext();
        Deployment deployment = (Deployment)pojoConverterContext.toPojo(source);
        List<Step> steps = this.getSteps(DefaultChange.with(deployment, null));
        UndeploymentTask undeploymentTask = new UndeploymentTask(deployment, steps, this.repositoryService, this.pojoConverter, pojoConverterContext);
        undeploymentTask.setLabel(String.format(Task.UNDEPLOYMENT_TASK_LABEL_FORMAT, deployment.getSource().getLabel(), deployment.getSource().getVersion(), deployment.getTarget()));
        return undeploymentTask;
    }

    public Task prepareRedeployment(ConfigurationItemEntity source, ConfigurationItemEntity target, Collection<ConfigurationItemEntity> mappingEntities) {
        return null;
    }

    @HttpResponseCodeResult(statusCode=400)
    public static class DeploymentException
    extends DeployitException {
        public DeploymentException(String message) {
            super(message);
        }
    }
}

