/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.exception.DeployitException;
import com.xebialabs.deployit.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.repository.ArtifactEntity;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.service.importer.DeployableArtifactImporter;
import com.xebialabs.deployit.service.importer.Exploder;
import com.xebialabs.deployit.service.importer.ImporterService;
import com.xebialabs.deployit.service.importer.PackageInfo;
import com.xebialabs.deployit.service.importer.PackageScanner;
import com.xebialabs.deployit.service.importer.UnpackedPackageManifestImporter;
import com.xebialabs.deployit.service.validation.Validator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ImporterServiceImpl
implements ImporterService {
    static final String UPLOADED_PACKAGE = "uploaded-package";
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private Validator validator;
    private File importablePackageDirectory;
    private List<DeployableArtifactImporter> artifactImporters = Lists.newArrayList();
    private static final Logger logger = LoggerFactory.getLogger(ImporterServiceImpl.class);

    public void setImportablePackageDirectory(File importablePackageDirectory) {
        this.importablePackageDirectory = importablePackageDirectory;
    }

    public void setArtifactImporters(List<DeployableArtifactImporter> artifactImporters) {
        this.artifactImporters = artifactImporters;
    }

    @Override
    public List<String> list() {
        ArrayList newArrayList = Lists.newArrayList(PackageScanner.scan(this.importablePackageDirectory));
        Collections.sort(newArrayList);
        return newArrayList;
    }

    @Override
    public PackageInfo preparePackage(String file) {
        PackageInfo packageInfo = new PackageInfo();
        packageInfo.originalPackage = file;
        File packageToImport = new File(this.importablePackageDirectory, file);
        if (PackageScanner.isExplodedPackage(packageToImport)) {
            logger.debug("Preparing unpacked package {}", (Object)packageToImport);
            packageInfo.explodedPackage = packageToImport;
        } else if (PackageScanner.isDarPackage(packageToImport)) {
            packageInfo.explodedPackage = Exploder.explode(packageToImport);
        } else {
            throw new NotFoundException("Cannot import " + file + " because it does not exist or is not a .dar or unpacked package", new Object[0]);
        }
        this.updatePackageInfoWithManifestValues(packageInfo);
        return packageInfo;
    }

    private void updatePackageInfoWithManifestValues(PackageInfo packageInfo) {
        File manifestFileForUnpackedPackage = PackageScanner.getManifestFileForUnpackedPackage(packageInfo.explodedPackage);
        Manifest manifest = UnpackedPackageManifestImporter.readManifest(manifestFileForUnpackedPackage);
        packageInfo.applicationName = UnpackedPackageManifestImporter.getApplicationName(manifest);
        packageInfo.applicationVersion = UnpackedPackageManifestImporter.getApplicationVersion(manifest);
    }

    @Override
    public PackageInfo preparePackage(byte[] uploadedPackage) {
        PackageInfo packageInfo = new PackageInfo();
        try {
            File archive = File.createTempFile(UPLOADED_PACKAGE, ".dar");
            IOUtils.copy((InputStream)new ByteArrayInputStream(uploadedPackage), (OutputStream)new FileOutputStream(archive));
            if (PackageScanner.isDarPackage(archive)) {
                logger.debug("Preparing uploaded packed package {}", (Object)archive);
                packageInfo.originalPackage = archive.getAbsolutePath();
                packageInfo.explodedPackage = Exploder.explode(archive);
                this.updatePackageInfoWithManifestValues(packageInfo);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot import uploaded package because it does not exist or is not a .dar or unpacked package", e);
        }
        return packageInfo;
    }

    @Override
    public String importPackage(PackageInfo packageInfo) {
        File manifestFileForUnpackedPackage = PackageScanner.getManifestFileForUnpackedPackage(packageInfo.explodedPackage);
        Manifest manifest = UnpackedPackageManifestImporter.readManifest(manifestFileForUnpackedPackage);
        ArrayList toCreate = Lists.newArrayList();
        ConfigurationItemEntity applicationEntity = UnpackedPackageManifestImporter.createApplicationEntity(manifest);
        if (this.repositoryService.checkNodeExists(applicationEntity.getId())) {
            applicationEntity = (ConfigurationItemEntity)this.repositoryService.read(applicationEntity.getId());
        } else {
            toCreate.add(applicationEntity);
        }
        ConfigurationItemEntity deploymentPackage = UnpackedPackageManifestImporter.createDeploymentPackageEntity(manifest, applicationEntity);
        if (this.repositoryService.checkNodeExists(deploymentPackage.getId())) {
            throw new ImportFailedException("The package %s is already imported.", deploymentPackage.getId());
        }
        toCreate.add(deploymentPackage);
        for (Map.Entry<String, Attributes> entry : manifest.getEntries().entrySet()) {
            if (UnpackedPackageManifestImporter.isMiddlewareResource(entry)) {
                ConfigurationItemEntity resource = UnpackedPackageManifestImporter.createMiddlewareResourceEntity(deploymentPackage, packageInfo.explodedPackage, entry);
                toCreate.add(resource);
                continue;
            }
            ArtifactEntity artifact = UnpackedPackageManifestImporter.createArtifactEntity(deploymentPackage, packageInfo.explodedPackage, entry, this.artifactImporters);
            toCreate.add(artifact);
        }
        RepositoryObjectEntity[] toCreateArray = (ConfigurationItemEntity[])Iterables.toArray((Iterable)toCreate, ConfigurationItemEntity.class);
        ArrayList messages = Lists.newArrayList();
        for (ConfigurationItemEntity entity : toCreate) {
            Validator.Validations validations = this.validator.validate(entity, toCreateArray);
            messages.addAll(validations);
        }
        if (!messages.isEmpty()) {
            throw new ImportFailedException("Import failed with the following validation errors %s", ((Object)messages).toString());
        }
        this.repositoryService.create(toCreateArray);
        return deploymentPackage.getId();
    }

    @Override
    public void cleanUp(PackageInfo packageInfo) {
        if (packageInfo.originalPackage.endsWith("dar")) {
            FileUtils.deleteQuietly((File)packageInfo.explodedPackage);
        }
        if (packageInfo.originalPackage.contains(UPLOADED_PACKAGE)) {
            FileUtils.deleteQuietly((File)new File(packageInfo.originalPackage));
        }
    }

    @HttpResponseCodeResult(statusCode=400)
    class ImportFailedException
    extends DeployitException {
        public ImportFailedException(String template, Object ... args) {
            super(template, args);
        }
    }
}

