/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.exception;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.exception.HttpResponseCodeResult;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;

@HttpResponseCodeResult
public class DeployitException
extends RuntimeException {
    private List<String> errors;

    public DeployitException() {
        this.errors = Lists.newArrayList();
    }

    public DeployitException(String message) {
        this.errors = Lists.newArrayList();
        this.errors.add(message);
    }

    public DeployitException(String messageTemplate, Object ... params) {
        this.errors = Lists.newArrayList((Object[])new String[]{String.format(messageTemplate, params)});
    }

    public DeployitException(Throwable cause, String messageTemplate, Object ... params) {
        super(cause);
        this.errors = Lists.newArrayList((Object[])new String[]{String.format(messageTemplate, params)});
    }

    public DeployitException(Throwable cause) {
        super(cause);
        this.errors = Lists.newArrayList();
    }

    public void add(String messageTemplate, Object ... params) {
        this.errors.add(String.format(messageTemplate, params));
    }

    public void addAll(Collection<String> messages) {
        this.errors.addAll(messages);
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<String> getErrors() {
        return this.errors;
    }

    @Override
    public String getMessage() {
        return StringUtils.join(this.errors, (String)"\n");
    }
}

