/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.translation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.MappingInfo;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.DeploymentPackage;
import com.xebialabs.deployit.ci.Environment;
import com.xebialabs.deployit.ci.MiddlewareResource;
import com.xebialabs.deployit.ci.artifact.DeployableArtifact;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import com.xebialabs.deployit.ci.mapping.Mapping;
import com.xebialabs.deployit.exception.DeployitException;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyType;
import com.xebialabs.deployit.reflect.ConfigurationItemReflectionUtils;
import com.xebialabs.deployit.service.deployment.DeploymentService;
import com.xebialabs.deployit.typedescriptor.ConfigurationItemTypeDescriptorRepository;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
public class MappingGenerator {
    @Autowired
    private ConfigurationItemTypeDescriptorRepository repository;
    private static Field labelField;
    private static Field sourceField;
    private static Field targetField;

    public List<MappingInfo> generateMappingsForInitialDeployment(DeploymentPackage pkg, Environment env, String mappingType) {
        Deployment deployment = new Deployment(pkg, env);
        deployment.setLabel(DeploymentService.generateDeploymentLabel(pkg, env));
        ArrayList initialMappings = Lists.newArrayList();
        for (Serializable eachPkgMember : pkg.getAllMembers()) {
            List<MappingInfo> mappingsInfo = this.createInitialMappings(deployment, eachPkgMember, mappingType);
            initialMappings.addAll(mappingsInfo);
        }
        return initialMappings;
    }

    public List<MappingInfo> generateMappingsForUpgradeDeployment(Deployment d, DeploymentPackage newPkg) {
        ArrayList generatedMappingsForUpgrade = Lists.newArrayList();
        for (Mapping each : d.getMappings()) {
            MappingInfo generatedMappingForUpgrade = this.upgradeMapping(each, d, newPkg);
            if (generatedMappingForUpgrade == null) continue;
            generatedMappingsForUpgrade.add(generatedMappingForUpgrade);
        }
        return generatedMappingsForUpgrade;
    }

    private List<MappingInfo> createInitialMappings(Deployment deployment, Serializable pkgMember, String mappingType) {
        ArrayList mappingsCreated = Lists.newArrayList();
        for (Serializable eachEnvMember : deployment.getTarget().getMembers()) {
            ConfigurationItemDescriptor descriptor = mappingType == null ? this.findFirstMatchingMappingDescriptor(pkgMember, eachEnvMember) : this.getDescriptorIfMappingIsCompatible(pkgMember, eachEnvMember, mappingType);
            if (descriptor == null) continue;
            mappingsCreated.add(new MappingInfo(this.createMapping(deployment, pkgMember, eachEnvMember, descriptor), true));
        }
        return mappingsCreated;
    }

    private ConfigurationItemDescriptor findFirstMatchingMappingDescriptor(Serializable pkgMember, Serializable envMember) {
        List<String> allPkgMemberTypes = this.getAllTypes(pkgMember.getClass());
        List<String> allEnvMemberTypes = this.getAllTypes(envMember.getClass());
        for (ConfigurationItemDescriptor eachDescriptor : this.repository.getDescriptors()) {
            if (!this.isMappingDescriptor(eachDescriptor) || !allPkgMemberTypes.contains(eachDescriptor.getMappingSourceType()) || !allEnvMemberTypes.contains(eachDescriptor.getMappingTargetType())) continue;
            return eachDescriptor;
        }
        return null;
    }

    private ConfigurationItemDescriptor getDescriptorIfMappingIsCompatible(Serializable pkgMember, Serializable envMember, String mappingType) {
        ConfigurationItemDescriptor descriptor = this.repository.getDescriptorByShortName(mappingType);
        List<String> allPkgMemberTypes = this.getAllTypes(pkgMember.getClass());
        List<String> allEnvMemberTypes = this.getAllTypes(envMember.getClass());
        if (descriptor != null && this.isMappingDescriptor(descriptor) && allPkgMemberTypes.contains(descriptor.getMappingSourceType()) && allEnvMemberTypes.contains(descriptor.getMappingTargetType())) {
            return descriptor;
        }
        return null;
    }

    private Mapping<?, ?> createMapping(Deployment deployment, Serializable pkgMember, Serializable envMember, ConfigurationItemDescriptor descriptor) {
        Mapping mapping = (Mapping)descriptor.newInstance();
        String mappingLabel = this.generateMappingLabel(pkgMember, envMember);
        ReflectionUtils.setField((Field)labelField, (Object)mapping, (Object)mappingLabel);
        ReflectionUtils.setField((Field)sourceField, (Object)mapping, (Object)pkgMember);
        ReflectionUtils.setField((Field)targetField, (Object)mapping, (Object)envMember);
        if (descriptor.getPlaceholdersField() != null) {
            ReflectionUtils.setField((Field)descriptor.getPlaceholdersField(), (Object)mapping, this.generatePlaceholders(pkgMember));
        }
        mapping.postInit(deployment);
        return mapping;
    }

    private List<KeyValuePair> generatePlaceholders(Serializable pkgMember) {
        ConfigurationItemDescriptor descriptor = this.repository.getDescriptorForObject(pkgMember);
        ConfigurationItemPropertyDescriptor propertyDescriptor = descriptor.getPropertyDescriptor("placeholders");
        ArrayList<KeyValuePair> placeholders = new ArrayList<KeyValuePair>();
        if (propertyDescriptor != null) {
            Set placeholderSet = (Set)propertyDescriptor.getPropertyValueFromConfigurationItem((Object)pkgMember);
            for (String placeholder : placeholderSet) {
                placeholders.add(new KeyValuePair(placeholder, null));
            }
        }
        return placeholders;
    }

    private MappingInfo upgradeMapping(Mapping<?, ?> mapping, Deployment d, DeploymentPackage pkg) {
        Serializable source = mapping.getSource();
        List<Serializable> similarObjects = this.findSimilarObject(pkg, source);
        if (similarObjects.size() == 0) {
            return new MappingInfo(this.cloneMappingForUpgrade(mapping, source, pkg, d.getSource()), false);
        }
        if (similarObjects.size() == 1) {
            return new MappingInfo(this.cloneMappingForUpgrade(mapping, similarObjects.get(0), pkg, d.getSource()), true);
        }
        throw new DeployitException("Mapping " + mapping + " could not be upgraded since multiple similar items were found with the same identifying property value");
    }

    private Mapping<?, ?> cloneMappingForUpgrade(Mapping<?, ?> mapping, Serializable newSource, DeploymentPackage newPkg, DeploymentPackage oldPkg) {
        Mapping clonedMapping = (Mapping)BeanUtils.instantiate(mapping.getClass());
        ConfigurationItemDescriptor descriptor = this.repository.getDescriptorByClass(mapping.getClass());
        BeanUtils.copyProperties(mapping, (Object)clonedMapping);
        clonedMapping.setSource(newSource);
        clonedMapping.setLabel(this.generateMappingLabel(newSource, clonedMapping.getTarget()));
        this.cloneAndReplacePlaceholderFieldInMapping(newSource, (Mapping<Serializable, Serializable>)clonedMapping, descriptor);
        this.replaceCiReferencesInMappingToReferToSimilarObjectsInNewDeploymentPackage(clonedMapping, descriptor, newPkg, oldPkg);
        return clonedMapping;
    }

    private void cloneAndReplacePlaceholderFieldInMapping(Serializable newSource, Mapping<Serializable, Serializable> mapping, ConfigurationItemDescriptor descriptor) {
        Field placeholdersField = descriptor.getPlaceholdersField();
        if (placeholdersField != null) {
            try {
                List<KeyValuePair> newPlaceholders = this.generatePlaceholders(newSource);
                List oldPlaceholders = (List)placeholdersField.get(mapping);
                for (KeyValuePair oldPlaceholder : oldPlaceholders) {
                    KeyValuePair existingPlaceholder = this.getByKey(oldPlaceholder.getKey(), newPlaceholders);
                    if (existingPlaceholder != null) {
                        if (StringUtils.isBlank((String)oldPlaceholder.getValue())) {
                            existingPlaceholder.setValue("<empty>");
                            continue;
                        }
                        existingPlaceholder.setValue(oldPlaceholder.getValue());
                        continue;
                    }
                    newPlaceholders.add(oldPlaceholder);
                }
                placeholdersField.set(mapping, newPlaceholders);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Ask Jeroen", e);
            }
        }
    }

    private void replaceCiReferencesInMappingToReferToSimilarObjectsInNewDeploymentPackage(Mapping<?, ?> mapping, ConfigurationItemDescriptor descriptor, DeploymentPackage newPkg, DeploymentPackage oldPkg) {
        ConfigurationItemPropertyDescriptor[] propertyDescriptors;
        for (ConfigurationItemPropertyDescriptor propertyDescriptor : propertyDescriptors = descriptor.getPropertyDescriptors()) {
            if (propertyDescriptor.getName().equals("source") || propertyDescriptor.getName().equals("target")) continue;
            if (propertyDescriptor.getType() == ConfigurationItemPropertyType.CI) {
                this.replaceCiPropertyInMappingWithSimilarObjectInNewPackage(mapping, newPkg, oldPkg, propertyDescriptor);
                continue;
            }
            if (propertyDescriptor.getType() != ConfigurationItemPropertyType.SET_OF_CIS) continue;
            this.replaceSetOfCisPropertyInMappingWithSimilarObjectsInNewPackage(mapping, newPkg, oldPkg, propertyDescriptor);
        }
    }

    private void replaceCiPropertyInMappingWithSimilarObjectInNewPackage(Mapping<?, ?> mapping, DeploymentPackage newPkg, DeploymentPackage oldPkg, ConfigurationItemPropertyDescriptor propertyDescriptor) {
        Object mappingPropertyValue = propertyDescriptor.getPropertyValueFromConfigurationItem(mapping);
        if (this.thereIsAnIdenticalObjectInOldDeploymentPackage(oldPkg, mappingPropertyValue)) {
            Serializable similarObjectInNewPkg = this.findSimilarObject(newPkg, mappingPropertyValue, mapping, propertyDescriptor.getName());
            propertyDescriptor.setPropertyValueInConfigurationItem(mapping, (Object)similarObjectInNewPkg);
        }
    }

    private boolean thereIsAnIdenticalObjectInOldDeploymentPackage(DeploymentPackage pkg, Object serializableSource) {
        Serializable source = (Serializable)serializableSource;
        for (MiddlewareResource middlewareResource : pkg.getMiddlewareResources()) {
            if (!ConfigurationItemReflectionUtils.isIdentical((Serializable)middlewareResource, (Serializable)source)) continue;
            return true;
        }
        for (DeployableArtifact each : pkg.getDeployableArtifacts()) {
            if (!ConfigurationItemReflectionUtils.isIdentical((Serializable)each, (Serializable)source)) continue;
            return true;
        }
        return false;
    }

    private void replaceSetOfCisPropertyInMappingWithSimilarObjectsInNewPackage(Mapping<?, ?> mapping, DeploymentPackage newPkg, DeploymentPackage oldPkg, ConfigurationItemPropertyDescriptor propertyDescriptor) {
        Set setOfCis = (Set)propertyDescriptor.getPropertyValueFromConfigurationItem(mapping);
        if (setOfCis == null) {
            return;
        }
        HashSet newSetOfCis = Sets.newHashSet();
        for (Serializable ci : setOfCis) {
            if (this.thereIsAnIdenticalObjectInOldDeploymentPackage(oldPkg, ci)) {
                Serializable similarObjectInNewPkg = this.findSimilarObject(newPkg, ci, mapping, propertyDescriptor.getName());
                if (similarObjectInNewPkg == null) continue;
                newSetOfCis.add(similarObjectInNewPkg);
                continue;
            }
            newSetOfCis.add(ci);
        }
        propertyDescriptor.setPropertyValueInConfigurationItem(mapping, (Object)newSetOfCis);
    }

    private Serializable findSimilarObject(DeploymentPackage pkg, Object source, Mapping<?, ?> mapping, String mappingPropertyName) {
        List<Serializable> similarObjects = this.findSimilarObject(pkg, (Serializable)source);
        if (similarObjects.isEmpty()) {
            return null;
        }
        if (similarObjects.size() == 1) {
            return similarObjects.get(0);
        }
        throw new DeployitException("Mapping " + mapping + " could not be upgraded since multiple similar items were found with the same identifying property value for mapping property " + mappingPropertyName);
    }

    private List<Serializable> findSimilarObject(DeploymentPackage pkg, Serializable source) {
        ArrayList similarObjects = Lists.newArrayList();
        for (MiddlewareResource each : pkg.getMiddlewareResources()) {
            if (!ConfigurationItemReflectionUtils.isSimilar((Serializable)each, (Serializable)source)) continue;
            similarObjects.add(each);
        }
        for (MiddlewareResource each : pkg.getDeployableArtifacts()) {
            if (!ConfigurationItemReflectionUtils.isSimilar((Serializable)each, (Serializable)source)) continue;
            similarObjects.add(each);
        }
        return similarObjects;
    }

    private String generateMappingLabel(Serializable pkgMember, Serializable envMember) {
        String environmentMemberLabel = this.repository.getDescriptorForObject(envMember).getLabelValueFromConfigurationItem((Object)envMember);
        return environmentMemberLabel + "/" + this.getIdentifier(pkgMember);
    }

    private String getIdentifier(Serializable object) {
        StringBuilder builder = new StringBuilder();
        ConfigurationItemDescriptor descriptor = this.repository.getDescriptorForObject(object);
        for (ConfigurationItemPropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            Object value;
            if (!propertyDescriptor.isIdentifying() || (value = propertyDescriptor.getPropertyValueFromConfigurationItem((Object)object)) == null) continue;
            if (builder.length() > 0) {
                builder.append(":");
            }
            builder.append(value.toString().replace('/', '_'));
        }
        if (builder.length() == 0) {
            String ciLabel = descriptor.getLabelValueFromConfigurationItem((Object)object);
            builder.append(ciLabel.substring(ciLabel.lastIndexOf("/") + 1));
        }
        return builder.toString();
    }

    private boolean isMappingDescriptor(ConfigurationItemDescriptor eachDescriptor) {
        return eachDescriptor.getSuperClasses().contains(Mapping.class.getName());
    }

    private List<String> getAllTypes(Class<?> clazz) {
        ConfigurationItemDescriptor desc = this.repository.getDescriptorByClass(clazz);
        Preconditions.checkNotNull((Object)desc, (Object)("Cannnot find descriptor for " + clazz));
        return this.getAllTypesForDescriptor(desc);
    }

    private List<String> getAllTypesForDescriptor(ConfigurationItemDescriptor descriptor) {
        Preconditions.checkNotNull((Object)descriptor);
        ArrayList types = Lists.newArrayList();
        types.add(descriptor.getType());
        types.addAll(descriptor.getSuperClasses());
        types.addAll(descriptor.getInterfacesWithoutSerializable());
        return types;
    }

    private KeyValuePair getByKey(String key, List<KeyValuePair> placeHolders) {
        for (KeyValuePair keyValuePair : placeHolders) {
            if (!keyValuePair.getKey().equals(key)) continue;
            return keyValuePair;
        }
        return null;
    }

    static {
        try {
            labelField = BaseConfigurationItem.class.getDeclaredField("label");
            labelField.setAccessible(true);
            sourceField = Mapping.class.getDeclaredField("source");
            sourceField.setAccessible(true);
            targetField = Mapping.class.getDeclaredField("target");
            targetField.setAccessible(true);
        }
        catch (SecurityException e) {
            throw new Error(e);
        }
        catch (NoSuchFieldException e) {
            throw new Error(e);
        }
    }
}

