/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.StepExecutionContextListener;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecutionContext {
    private Map<String, Object> attributes;
    private Logger logger = LoggerFactory.getLogger(TaskExecutionContext.class);

    TaskExecutionContext() {
        this.attributes = Maps.newHashMap();
    }

    public TaskExecutionContext(Map<String, Object> existingAttributes) {
        this.attributes = existingAttributes;
    }

    Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    void setAttribute(String name, Object object) {
        this.attributes.put(name, object);
    }

    public void destroy() {
        for (Map.Entry<String, Object> each : this.attributes.entrySet()) {
            if (!(each.getValue() instanceof StepExecutionContextListener)) continue;
            try {
                ((StepExecutionContextListener)each.getValue()).contextDestroyed();
            }
            catch (Exception exc) {
                this.logger.error("Could not destroy context attribute " + each.getKey(), (Throwable)exc);
            }
        }
    }
}

