package com.xebialabs.deployit.typedescriptor;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.concurrent.atomic.AtomicReference;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 */
@Component
public class ConfigurationItemDescriptorRepositoryHolder {
	private static final Logger log = LoggerFactory.getLogger(ConfigurationItemDescriptorRepositoryHolder.class);

	private static final AtomicReference<ConfigurationItemTypeDescriptorRepository> REFERENCE = new AtomicReference<ConfigurationItemTypeDescriptorRepository>();

	/**
	 * Used by Spring. Do not invoke!
	 */
	@Autowired
	public ConfigurationItemDescriptorRepositoryHolder(ConfigurationItemTypeDescriptorRepository instance) {
		if (REFERENCE.getAndSet(checkNotNull(instance)) != null) {
			log.warn("Attempted to reinitialize holder with " + instance);
		}
	}

	public static ConfigurationItemTypeDescriptorRepository getDescriptorRepository() {
		return REFERENCE.get();
	}

	public static ConfigurationItemDescriptor getDescriptor(final RepositoryObjectEntity entity) {
		return getDescriptor(entity.getConfigurationItemTypeName());
	}

	public static ConfigurationItemDescriptor getDescriptor(final String configurationItemTypeName) {
		ConfigurationItemDescriptor descriptor = getDescriptorRepository().getDescriptorByType(configurationItemTypeName);
		if (descriptor == null) {
			throw new IllegalStateException("Cannot find a descriptor for configuration item type " + configurationItemTypeName);
		}
		return descriptor;
	}

}
