package com.xebialabs.deployit.translation;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.Change;

import java.io.Serializable;

/**
 */
public class DefaultChange<T extends Serializable> implements Change<T> {

	private T oldCI;
	private T newCI;

	public static <C extends Serializable> DefaultChange<C> with(C oldCI, C newCI) {
		return new DefaultChange<C>(oldCI, newCI);
	}

	DefaultChange(final T anOldCI, final T aNewCI) {
		Preconditions.checkArgument(anOldCI != null || aNewCI != null, "Old and new revision cannot both be null");
		this.oldCI = anOldCI;
		this.newCI = aNewCI;
	}

	@SuppressWarnings("unchecked")
    @Override
	public Class<T> getConfigurationItemClass() {
		return (Class<T>) (oldCI == null ? newCI : oldCI).getClass();
	}

	@Override
	public boolean isAddition() {
		return oldCI == null;
	}

	@Override
	public boolean isModification() {
		return oldCI != null && newCI != null;
	}

	@Override
	public boolean isDeletion() {
		return newCI == null;
	}

	@Override
	public T getOldRevision() {
		return oldCI;
	}

	@Override
	public T getNewRevision() {
		return newCI;
	}
}
