package com.xebialabs.deployit.task.labelparser;

import static com.google.common.base.Preconditions.checkArgument;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.xebialabs.deployit.task.Task;

public class UpgradeTaskLabelParser implements DeploymentTaskLabelParser {
	private Matcher matcher;
	private boolean matched;

	public UpgradeTaskLabelParser(String taskLabel) {
		String packageRegex = "^" + Task.UPGRADE_TASK_LABEL_FORMAT.replaceAll("%s", "(.*)") + "$";
		Pattern packagePattern = Pattern.compile(packageRegex);
		this.matcher = packagePattern.matcher(taskLabel);
		this.matched = matcher.find();
		checkArgument(matched, String.format("task label %s doesn't conform to the standard format %s", taskLabel, Task.UPGRADE_TASK_LABEL_FORMAT));

	}

	public String getApplication() {
		if (matched) {
			if (matcher.groupCount() > 0) {
				return matcher.group(1).substring(0, matcher.group(1).lastIndexOf("/"));
			}
		}
		return "";
	}

	public String getOldVersion() {
		if (matched) {
			if (matcher.groupCount() > 1) {
				return matcher.group(2);
			}
		}
		return "";
	}

	public String getVersion() {
		if (matched) {
			if (matcher.groupCount() > 2) {
				return matcher.group(3);
			}
		}
		return "";
	}

	public String getEnvironment() {
		if (matched) {
			if (matcher.groupCount() > 3) {
				return matcher.group(4);
			}
		}
		return "";
	}
}
