package com.xebialabs.deployit.task.deployment;

import java.util.Collection;
import java.util.List;
import java.util.Set;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.plugin.PojoConverter;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.SecurityCallback;
import com.xebialabs.deployit.security.SecurityTemplate;
import com.xebialabs.deployit.security.UsernameAndPasswordCredentials;
import com.xebialabs.deployit.task.Task;

@SuppressWarnings("serial")
public class UpgradeDeploymentTask extends Task {

	private final Collection<ConfigurationItemEntity> mappingEntities;
	private final ConfigurationItemEntity newDeploymentEntity;

	public UpgradeDeploymentTask(final Collection<ConfigurationItemEntity> mappingEntities, final ConfigurationItemEntity newDeploymentEntity,
	        List<Step> steps, RepositoryService repositoryService, PojoConverter pojoConverter, PojoConverter.Context... pojoConverterContexts) {
		super(steps, repositoryService, pojoConverter, pojoConverterContexts);
		this.mappingEntities = mappingEntities;
		this.newDeploymentEntity = newDeploymentEntity;
	}

	@SuppressWarnings("unchecked")
	@Override
	public void doAfterTaskStateChangedToDone() {
		UsernameAndPasswordCredentials owner = getOwnerCredentials();
		SecurityTemplate.executeAs(owner.getUsername(), owner.getPassword(), new SecurityCallback<Object>() {
			@Override
			public Object doAs() {
				// FIXME: would be nice to make all these changes in one JCR call!
				// Saving the original deployment object
				RepositoryObjectEntity existingDeployment = repositoryService.read(newDeploymentEntity.getId());

				Set<String> mappingIds = (Set<String>) existingDeployment.getValue("mappings");
				// remove the existing mapping and update the deployment
				existingDeployment.addValue("mappings", Sets.newHashSet());
				repositoryService.update(existingDeployment);
				// delete the existing mappings
				for (String each : mappingIds) {
					repositoryService.delete(each);
				}

				// Save the mappings that are stored as subnodes of the deployment that was just created
				for (ConfigurationItemEntity each : mappingEntities) {
					String mappingId = each.getId();
					for (int i = 0;; i++) {
						if (i != 0) {
							each.setId(mappingId + " (" + i + ")");
						}
						try {
							repositoryService.create(each);
							break;
						} catch (ItemAlreadyExistsException exc) {
							// Ignored, we increment the id.
						}
					}
					Set<String> newMappingIds = (Set<String>) newDeploymentEntity.getValue("mappings");
					newMappingIds.remove(mappingId);
					newMappingIds.add(each.getId());
				}

				// Update the deployment to have a creating task id and to refer to the mappings that were just created
				newDeploymentEntity.setCreatingTaskId(getId());
				repositoryService.update(newDeploymentEntity);

				return null;
			}
		});

	}
	
	@Override
	public boolean isDeploymentTask() {
		return true;
	}
}
