package com.xebialabs.deployit.task.deployment;

import java.util.List;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.mapping.Mapping;
import com.xebialabs.deployit.plugin.PojoConverter;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.SecurityCallback;
import com.xebialabs.deployit.security.SecurityTemplate;
import com.xebialabs.deployit.security.UsernameAndPasswordCredentials;
import com.xebialabs.deployit.task.Task;

@SuppressWarnings("serial")
public class UndeploymentTask extends Task {

	private Deployment deployment;

	public UndeploymentTask(final Deployment deployment, final List<Step> steps, final RepositoryService repositoryService, PojoConverter pojoConverter,
	        PojoConverter.Context... pojoConverterContexts) {
		super(steps, repositoryService, pojoConverter, pojoConverterContexts);
		this.deployment = deployment;
	}

	@Override
	public void doAfterTaskStateChangedToDone() {
		UsernameAndPasswordCredentials owner = getOwnerCredentials();
		SecurityTemplate.executeAs(owner.getUsername(), owner.getPassword(), new SecurityCallback<Object>() {
			@Override
			public Object doAs() {
				// First delete the deployment, otherwise, the mappings cannot be deleted as they're referenced.
				repositoryService.delete(deployment.getLabel());
				for (Mapping<?, ?> mapping : deployment.getMappings()) {
					repositoryService.delete(mapping.getLabel());
				}

				return null;
			}
		});
	}
}
