package com.xebialabs.deployit.task;

import java.util.Collection;
import java.util.List;

/**
 */
public interface TaskRegistry {

	public String registerTask(Task task);

	public Task getTask(String id);
	
	public void cancelTask(String id);

	public void updateTask(String id, Task task);

	public List<Task> getIncompleteTasksForUser(String username);

    Collection<Task> getAllArchivedTasks();

    Collection<Task> getTasks();
    
    public TaskArchive getTaskArchive();

    void destroy();
}
