package com.xebialabs.deployit.task;

import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.StepExecutionContextListener;

// FIXME: Remove "public" when no longer needed to support discovery in 1.3 plugin-api
public class TaskExecutionContext {

	private Map<String, Object> attributes;

	TaskExecutionContext() {
		attributes = Maps.newHashMap();
	}

	/**
	 * @deprecated Needed to support discovery in 1.3 plugin-api
	 */
	public TaskExecutionContext(Map<String, Object> existingAttributes) {
		attributes = existingAttributes;
	}

	/**
	 * @deprecated Needed to support discovery in 1.3 plugin-api
	 */
	public Map<String, Object> getAttributes() {
		return attributes;
	}

	Object getAttribute(String name) {
		return attributes.get(name);
	}

	void setAttribute(String name, Object object) {
		attributes.put(name, object);
	}

	public void destroy() {
		for (Map.Entry<String, Object> each : attributes.entrySet()) {
			if (each.getValue() instanceof StepExecutionContextListener) {
				try {
					logger.debug("Invoking StepExecutionContextListener on context attribute " + each.getKey());
					((StepExecutionContextListener) each.getValue()).contextDestroyed();
				} catch (Exception exc) {
					logger.error("Could not destroy context attribute " + each.getKey(), exc);
				}
			}
		}
		attributes.clear();
	}

	private Logger logger = LoggerFactory.getLogger(TaskExecutionContext.class);

}
