package com.xebialabs.deployit.task;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.xebialabs.deployit.Step;

import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("serial")
class StepList extends ArrayList<TaskStep> {

	private volatile int currentStepNr;

    StepList(List<? extends Step> steps) {
       super(new ArrayList<TaskStep>(Collections2.transform(steps, new Function<Step, TaskStep>() {
            @Override
            public TaskStep apply(final Step from) {
                return new TaskStep(from);
            }
        })));
        currentStepNr = 0;
    }

    StepList(List<TaskStep> steps, int currentStepNr) {
        super(steps);
        this.currentStepNr = currentStepNr;
    }

    public int getNrOfSteps() {
        return size();
    }

    public int getCurrentStepNr() {
        return currentStepNr;
    }

    public TaskStep getStep(int stepNr) {
        if (stepNr < 1 || stepNr > getNrOfSteps()) {
            throw new IllegalArgumentException(stepNr + " is not a valid step number");
        }
        return get(stepNr - 1);
    }

    public TaskStep getNextStep() {
        return getStep(++currentStepNr);
    }

    public boolean hasMoreSteps() {
        return currentStepNr < getNrOfSteps();
    }

    public void rollback() {
        currentStepNr--;
    }
}
