package com.xebialabs.deployit.service.validation;

import com.xebialabs.deployit.reflect.ConfigurationItemPropertyDescriptor;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import static java.lang.String.format;

public class ValidationMessage {
    private String message;
    private String id;
    private String fieldName;

    public ValidationMessage(final RepositoryObjectEntity ci, final ConfigurationItemPropertyDescriptor propertyDescriptor, final String message, final Object... params) {
        this(ci, propertyDescriptor.getName(), message, params);
    }

    public ValidationMessage(final RepositoryObjectEntity ci, final String key, final String message, final Object... params) {
        this.id = ci.getId();
        this.fieldName = key;
        this.message = format(message, params);
    }

    public String getMessage() {
        return message;
    }

    public String getId() {
        return id;
    }

    public String getFieldName() {
        return fieldName;
    }

    @Override
    public String toString() {
        return new StringBuilder("ValidationMessage[id=").append(id).append(", field=").append(fieldName).append(", message=").append(message).append("]").toString();
    }
}