package com.xebialabs.deployit.service.importer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;

import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.ci.artifact.Folder;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.repository.ArtifactEntity;

public class SingleFileTypeArtifactImporter extends DeployableArtifactImporter {

	@Override
	public boolean canHandle(ConfigurationItemDescriptor typeDescriptor) {
		return !typeDescriptor.getSuperClasses().contains(Folder.class.getName());
	}

	@Override
	public void importArtifact(final ArtifactEntity artifact, final File artifactFile, ConfigurationItemDescriptor typeDescriptor) {
		doImport(artifact, artifactFile);
		if (typeDescriptor.getPropertyDescriptor("placeholders") != null) {
			parsePlaceholders(artifact, artifactFile);
		}
	}

	public void doImport(final ArtifactEntity artifact, final File artifactFile) {
		byte[] artifactAsBytes;
		try {
			artifactAsBytes = FileUtils.readFileToByteArray(artifactFile);
		} catch (IOException e) {
			throw new ImporterException(e, "Unable to read " + artifactFile);
		}
		artifact.setData(new ByteArrayInputStream(artifactAsBytes));
	}

	private static final Logger logger = LoggerFactory.getLogger(SingleFileTypeArtifactImporter.class);

}
