package com.xebialabs.deployit.service.importer;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;

public class PlaceHolderHelper {

	private static final String REGEX_ANT_STYLE_PLACEHOLDER = "\\$\\{([A-Za-z0-9\\-_.]*)\\}";
	private static Pattern pattern = Pattern.compile(REGEX_ANT_STYLE_PLACEHOLDER);

	/**
	 * Parses placeholders(ant style e.g. ${some.property} from the text input stream)
	 * 
	 * @param in
	 *            input stream containing place-holders
	 * @return list of parsed place-holders
	 */
	public static List<String> parsePlaceholders(InputStream in) {
		Set<String> placeholders = Sets.newLinkedHashSet();

		Scanner scanner = new Scanner(in);
		try {
			while (scanner.hasNextLine()) {
				placeholders.addAll(getNextPlaceholder(scanner.nextLine()));
			}
		} finally {
			scanner.close();
		}
		return new ArrayList<String>(placeholders);
	}

	private static List<String> getNextPlaceholder(String line) {
		List<String> placeholders = Lists.newArrayList();
		Matcher matcher = pattern.matcher(line);
		while (matcher.find()) {
			String placeholder = matcher.group(1);
			placeholders.add(placeholder);
		}

		return placeholders;
	}
}
