package com.xebialabs.deployit.service.importer;

import com.google.common.collect.Sets;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.util.Set;

/**
 */
class PackageScanner {

	static Set<String> scan(File directory) {
		if (!directory.exists() || !directory.isDirectory()) {
			throw new IllegalArgumentException("Directory " + directory.getAbsolutePath() + " does not exist or is not a directory");
		}
		
		Set<String> result = Sets.newHashSet();
		if (logger.isDebugEnabled())
			logger.debug("Listing importable packages in " + directory.getAbsolutePath());

		scanDirectory(directory, result, "");

		if (logger.isDebugEnabled())
			logger.debug("Returning the following packages: " + result );

		return result;

	}

	private static void scanDirectory(final File directory, final Set<String> result, String pathPrefix) {
		final File[] files = directory.listFiles();
		if (logger.isDebugEnabled())
			logger.debug("Found " + files.length + " possible packages.");

		for (File f : files) {
			if (isExplodedPackage(f)) {
				result.add(pathPrefix + f.getName());
			} else if (isDarPackage(f)) {
				result.add(pathPrefix + f.getName());
			} else if (f.isDirectory()) {
				scanDirectory(f, result, pathPrefix + f.getName() + "/");
			}
		}
	}


	static boolean isDarPackage(final File f) {
		return f.isFile() && StringUtils.endsWithIgnoreCase(f.getName(),".dar");
	}

	static boolean isExplodedPackage(final File f) {
		if (f.isDirectory()) {
			final File manifestFile = getManifestFileForUnpackedPackage(f);
			return (manifestFile.exists());
		} else {
			return false;
		}
	}

	static File getManifestFileForUnpackedPackage(final File f) {
		final File manifestFile = new File(new File(f, "META-INF"), "MANIFEST.MF");
		return manifestFile;
	}

	private static final Logger logger = LoggerFactory.getLogger(PackageScanner.class);
}
