package com.xebialabs.deployit.service.importer;

import org.apache.commons.io.IOUtils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/**
 */
public class Imploder {

	public static byte[] implode(File folder) throws IOException {
		final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
		final ZipOutputStream zipper = new ZipOutputStream(outputStream);
		try {
			for (File file : folder.listFiles()) {
				writeEntry(zipper, file, "");
			}
		} finally {
			zipper.close();
		}

		return outputStream.toByteArray();
	}

	private static void writeEntry(final ZipOutputStream zipper, final File file, String path) throws IOException {
		if (file.isDirectory()) {
			zipper.putNextEntry(new ZipEntry(path + file.getName() + "/"));
			writeDirectoryContents(zipper, file, path);
		} else {
			final ZipEntry zipEntry = new ZipEntry(path + file.getName());
			zipper.putNextEntry(zipEntry);
			IOUtils.copy(new FileInputStream(file), zipper);
			zipper.closeEntry();
		}
	}

	private static void writeDirectoryContents(final ZipOutputStream zipper, final File folder, String path) throws IOException {
		for (File file : folder.listFiles()) {
			writeEntry(zipper, file, path + folder.getName() + "/");
		}
	}
}
