package com.xebialabs.deployit.service.importer;

import java.io.File;
import java.util.Set;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.repository.ArtifactEntity;

public abstract class DeployableArtifactImporter {

	/**
	 * If this placeholderReader can handle the importing of entity
	 * 
	 * @param itemDescriptor
	 *            , the {@link ConfigurationItemDescriptor} of the entity
	 * @return boolean to indicate if the placeholder reader can parse the entity or not
	 */
	public abstract boolean canHandle(ConfigurationItemDescriptor typeDescriptor);

	protected abstract void doImport(ArtifactEntity artifact, File artifactFile);

	public void importArtifact(final ArtifactEntity artifact, final File artifactFile, ConfigurationItemDescriptor typeDescriptor) {
		doImport(artifact, artifactFile);
		if (typeDescriptor.getPropertyDescriptor("placeholders") != null) {
			Set<String> placeholders = parsePlaceholders(artifact, artifactFile);
			setPlaceholdersInArtifact(artifact, placeholders);
		}
	}

	private void setPlaceholdersInArtifact(ArtifactEntity artifact, Set<String> placeholders) {
		artifact.addValue("placeholders", placeholders);
	}

	/**
	 * Override it if placeholder parsing logic is to be implemented. Default implementation simply returns empty placeholders list
	 * 
	 * @param artifact
	 * @param artifactFile
	 * @return Set of placeholders found during parsing of the artifact
	 */
	protected Set<String> parsePlaceholders(ArtifactEntity artifact, File artifactFile) {
		return Sets.newHashSet();
	}
}
