package com.xebialabs.deployit.security.permission;

import com.xebialabs.deployit.ConfigurationItemRoot;

import static com.xebialabs.deployit.checks.Checks.checkArgument;

public class UpgradeImportHandler extends PermissionHandler {

	@Override
	protected void handle(String user, Action action) {
		permission(Permission.IMPORT_UPGRADE, user, action);
		privileges(ADD_CHILD_NODES_PRIVILEGES, user, "Applications", action);
	}

	@Override
	protected void handle(String user, String onConfigurationItem, Action action) {
		checkArgument(onConfigurationItem.startsWith(ConfigurationItemRoot.APPLICATIONS.getRootNodeName()), "%s is not an Application", onConfigurationItem);
		permission(Permission.IMPORT_UPGRADE, user, onConfigurationItem, action);
		privileges(ADD_CHILD_NODES_PRIVILEGES, user, onConfigurationItem, action);
	}

	@Override
	Permission getPermission() {
		return Permission.IMPORT_UPGRADE;
	}
}
