package com.xebialabs.deployit.security.permission;

import com.xebialabs.deployit.ConfigurationItemRoot;
import com.xebialabs.deployit.jcr.JcrConstants;
import com.xebialabs.deployit.repository.JcrRepositoryServiceHolder;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;

import java.util.Collection;

import static com.xebialabs.deployit.checks.Checks.checkArgument;

public class UpgradeDeploymentHandler extends PermissionHandler {

	@Override
	protected void handle(String user, Action action) {
		permission(Permission.DEPLOY_UPGRADE, user, action);
		privileges(ADD_CHILD_NODES_PRIVILEGES, user, "Environments", action);
		privileges(ADD_CHILD_NODES_PRIVILEGES, user, "Infrastructure", action);
		privileges(REMOVE_CHILD_NODES_PRIVILEGES, user, "Infrastructure", action);
		privileges(ADD_CHILD_NODES_PRIVILEGES, user, JcrConstants.TASKS_NODE_NAME, action);
	}

	@Override
	protected void handle(String user, String onConfigurationItem, Action action) {
		checkArgument(onConfigurationItem.startsWith(ConfigurationItemRoot.ENVIRONMENTS.getRootNodeName()), "%s is not an Environment", onConfigurationItem);
		permission(Permission.DEPLOY_UPGRADE, user, onConfigurationItem, action);
		privileges(ADD_CHILD_NODES_PRIVILEGES, user, onConfigurationItem, action);
		final RepositoryObjectEntity objectEntity = JcrRepositoryServiceHolder.getRepositoryService().read(onConfigurationItem);
		privileges(ADD_CHILD_NODES_PRIVILEGES, user, (Collection<String>) objectEntity.getValue("members"), action);
		privileges(REMOVE_CHILD_NODES_PRIVILEGES, user, (Collection<String>) objectEntity.getValue("members"), action);
		privileges(ADD_CHILD_NODES_PRIVILEGES, user, JcrConstants.TASKS_NODE_NAME, action);
	}

	@Override
	Permission getPermission() {
		return Permission.DEPLOY_UPGRADE;
	}
}
