package com.xebialabs.deployit.security.permission;

import com.xebialabs.deployit.security.SecurityServiceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

public class PermissionHelper {
	static void grantPermission(Permission permission, String user, String onConfigurationItem) {
		grantPermission(constructPermissionName(permission, onConfigurationItem), user);
	}

	static void grantPermission(Permission permission, String user) {
		grantPermission(permission.getPermissionName(), user);
	}

	private static void grantPermission(String permission, String user) {
		SecurityServiceLocator.getPermissionService().grantPermission(permission, user);
	}

	static void revokePermission(Permission permission, String user, String onConfigurationItem) {
		revokePermission(constructPermissionName(permission, onConfigurationItem), user);
	}

	static void revokePermission(Permission permission, String user) {
		revokePermission(permission.getPermissionName(), user);
	}

	private static void revokePermission(String permission, String user) {
		SecurityServiceLocator.getPermissionService().denyPermission(permission, user);
	}

	static boolean hasPermission(Permission permission) {
		return hasPermission(permission.getPermissionName());
	}

	private static boolean hasPermission(String permission) {
		return SecurityServiceLocator.getPermissionService().hasPermission(permission);
	}

	static boolean hasPermission(Permission permission, List<String> onConfigurationItems) {
		boolean allowed = !onConfigurationItems.isEmpty();
		for (String onConfigurationItem : onConfigurationItems) {
			allowed = allowed && hasPermission(permission, onConfigurationItem);
		}
		return allowed || hasPermission(permission);
	}

	private static boolean hasPermission(Permission permission, String onConfigurationItem) {
		return hasPermission(constructPermissionName(permission, onConfigurationItem));
	}

	static boolean hasPermission(Permission permission, String principal, String onConfigurationItem) {
		return SecurityServiceLocator.getPermissionService().hasPermission(constructPermissionName(permission, onConfigurationItem), principal);
	}

	private static String constructPermissionName(Permission permission, String onConfigurationItem) {
		final StringBuilder builder = new StringBuilder(permission.getPermissionName());
		if (onConfigurationItem != null) {
			logger.info("constructing permission: {} with {} ", builder.toString(), onConfigurationItem);
			builder.append("_").append(onConfigurationItem.replaceAll("/", "\\$"));
		}
		return builder.toString();
	}

	private static final Logger logger = LoggerFactory.getLogger(PermissionHelper.class);
}
