package com.xebialabs.deployit.security.permission;

public enum Permission {
	LOGIN("login", new LoginHandler()),
	READ("read", new ReadHandler()),
	IMPORT_INITIAL("import#initial", new InitialImportHandler()),
	IMPORT_UPGRADE("import#upgrade", new UpgradeImportHandler()),
	DEPLOY_INITIAL("deploy#initial", new InitialDeploymentHandler()),
	DEPLOY_UPGRADE("deploy#upgrade", new UpgradeDeploymentHandler()),
	DISCOVERY("discovery", new DiscoveryHandler()),
	UNDEPLOY("deploy#undeploy", new UndeploymentHandler()),
	EDIT_REPO("repo#edit", new EditRepositoryHandler());

	private PermissionHandler permissionHandler;
	private String permissionName;


	Permission(String permissionName, PermissionHandler permissionHandler) {
		this.permissionName = permissionName;
		this.permissionHandler = permissionHandler;
	}

	public static Permission find(String permissionName) {
		for (Permission permission : values()) {
			if (permission.permissionName.equals(permissionName)) {
				return permission;
			}
		}
		return null;
	}

	public PermissionHandler getPermissionHandler() {
		return permissionHandler;
	}

	public String getPermissionName() {
		return permissionName;
	}
}
