package com.xebialabs.deployit.security.permission;

import com.xebialabs.deployit.jcr.JcrConstants;

import static com.google.common.collect.Lists.newArrayList;

public class LoginHandler extends PermissionHandler {

	@Override
	protected void handle(String user, Action action) {
		permission(Permission.LOGIN, user, action);
		privileges(newArrayList(JCR_READ), user, "", action);
		final Action rootAction = action == Action.GRANT ? Action.DENY : Action.REVOKE;
		privileges(newArrayList(JCR_READ), user, newArrayList("Environments", "Applications", "Infrastructure", JcrConstants.TASKS_NODE_NAME, JcrConstants.ARCHETYPE_ROOT_NODE_NAME), rootAction);
		limitedPrivileges(newArrayList(JCR_READ), user, newArrayList("Environments", "Applications", "Infrastructure", JcrConstants.TASKS_NODE_NAME, JcrConstants.ARCHETYPE_ROOT_NODE_NAME), action);
	}

	@Override
	Permission getPermission() {
		return Permission.LOGIN;
	}
}
