package com.xebialabs.deployit.security;

import java.util.Collection;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

import com.google.common.collect.Lists;

@SuppressWarnings("serial")
public class UsernameAndPasswordCredentials implements Authentication {

	private String username;
	private String password;

	public UsernameAndPasswordCredentials(final String username, final String password) {
		this.username = username;
		this.password = password;
	}

	public String getUsername() {
		return username;
	}

	public String getPassword() {
		return password;
	}

	@Override
	public Collection<GrantedAuthority> getAuthorities() {
		return Lists.newArrayList();
	}

	@Override
	public Object getCredentials() {
		return password;
	}

	@Override
	public Object getDetails() {
		return null;
	}

	@Override
	public Object getPrincipal() {
		return username;
	}

	@Override
	public boolean isAuthenticated() {
		return true;
	}

	@Override
	public void setAuthenticated(final boolean isAuthenticated) throws IllegalArgumentException {
		// no-op
	}

	@Override
	public String getName() {
		return username;
	}
}
