package com.xebialabs.deployit.repository;

import java.util.Calendar;
import java.util.Map;

import com.google.common.collect.Maps;

/**
 */
public class SearchParameters {

	boolean archetypes;

	String configurationItemTypeName;

	String parent;

	String id;

	Map<String, String> properties = Maps.newHashMap();

	Calendar at;
	
	String creatingTaskId;

	long page = 0;

	long resultsPerPage = 0;

	public SearchParameters setConfigurationItemType(String configurationItemTypeName) {
		this.configurationItemTypeName = configurationItemTypeName;
		return this;
	}

	public SearchParameters setArchetypes() {
		this.archetypes = true;
		return this;
	}

	public SearchParameters setConfigurationItems() {
		this.archetypes = false;
		return this;
	}

	public SearchParameters addProperty(String key, String value) {
		properties.put(key, value);
		return this;
	}

	public SearchParameters setParent(String parent) {
		this.parent = parent;
		return this;
	}

	public SearchParameters setId(final String id) {
		this.id = id;
		return this;
	}

	public SearchParameters setAt(final Calendar at) {
		this.at = at;
		return this;
	}
	
	public SearchParameters setCreatingTaskId(final String creatingTaskId) {
		this.creatingTaskId = creatingTaskId;
		return this;
	}

	public SearchParameters setPage(long page) {
		this.page = page;
		return this;
	}

	public SearchParameters setResultsPerPage(long nrOfResults) {
		this.resultsPerPage = nrOfResults;
		return this;
	}
}
