package com.xebialabs.deployit.repository;

import static org.apache.commons.lang.StringUtils.lastIndexOf;
import static org.apache.commons.lang.StringUtils.stripStart;

import com.xebialabs.deployit.ConfigurationItemRoot;

public class JcrPathHelper {

	public static String getAbsolutePathFromId(final String id) {
		return "/" + id;
	}

	public static String getIdFromAbsolutePath(final String absPath) {
		return stripStart(absPath, "/");
	}

	public static String toValidNodeName(String str) {
		return str.replace('/', '_');
	}

	public static String buildId(ConfigurationItemRoot root, String... pathComponents) {
		return buildId(root.getRootNodeName(), pathComponents);
	}

	public static String buildId(String parentId, String... pathComponents) {
		StringBuilder b = new StringBuilder();
		b.append(parentId);
		for (String each : pathComponents) {
			b.append('/').append(each);
		}
		return b.toString();
	}

	public static String getParentId(String id) {
		int lastSlashPos = lastIndexOf(id, '/');
		if (lastSlashPos > 0) {
			return id.substring(0, lastSlashPos);
		} else {
			return "";
		}
	}

}
