package com.xebialabs.deployit.repository;

import java.util.List;
import java.util.Map;

import com.google.common.collect.Maps;

/**
 * FIXME: Can we get rid of this class? Or move it to a test.support package?
 */
public class InMemoryRepositoryService implements RepositoryService {
	private Map<String, RepositoryObjectEntity> store = Maps.newHashMap();

	@Override
	public <T extends RepositoryObjectEntity> void create(final T... entities) {
		checkThatEntitiesDoNotExist(entities);
        storeEntities(entities);
    }

    private void checkThatEntitiesDoNotExist(final RepositoryObjectEntity[] entities) {
        for (RepositoryObjectEntity entity : entities) {
            if (store.containsKey(entity.getId())) {
			    throw new IllegalStateException("Entity " + entity.getId() + " already exists and cannot be created twice.");
		    }
        }
    }

    private void storeEntities(final RepositoryObjectEntity[] entities) {
        for (RepositoryObjectEntity entity : entities) {
            store.put(entity.getId(), entity);
        }
    }

	@SuppressWarnings("unchecked")
    @Override
	public <T extends RepositoryObjectEntity> T read(final String id) {
		return (T) store.get(id);
	}

	@Override
	public <T extends RepositoryObjectEntity> T readFully(final String id) {
		return this.<T>read(id);
	}

	@Override
	public <T extends RepositoryObjectEntity> void update(final T entity) {
		if (!store.containsKey(entity.getId())) {
			throw new IllegalStateException("Cannot update nonexisting");
		}
		store.put(entity.getId(), entity);
	}

	@Override
	public boolean delete(final String id) {
		return store.remove(id) != null;
	}

	@Override
	public List<String> list(final SearchParameters criteria) {
		throw new UnsupportedOperationException("Ask Jeroen");
	}

	@Override
    public <T extends RepositoryObjectEntity> List<T> listEntities(SearchParameters parameters) {
		throw new UnsupportedOperationException("Ask Robert and Vincent");
    }

	@Override
	public boolean checkNodeExists(final String id) {
		return store.containsKey(id);
	}

}
