package com.xebialabs.deployit.repository;

import java.util.Map;

import org.springframework.stereotype.Component;

@Component
public class Flattener {

    public FlattenedEntity flatten(RepositoryObjectEntity entity) {
        FlattenedEntity flattened = new FlattenedEntity(entity);
        flattenArchetypes(entity.getConfigurationItemArchetype(), flattened);
        storeValues(entity.getValues(), flattened);

        return flattened;
    }

    private void flattenArchetypes(final ArchetypeEntity archetype, final RepositoryObjectEntity flattened) {
        if (archetype != null) {
            flattenArchetypes(archetype.getConfigurationItemArchetype(), flattened);
            storeValues(archetype.getValues(), flattened);
        }

    }

    private void storeValues(final Map<String, Object> values, final RepositoryObjectEntity flattened) {
        for (String key : values.keySet()) {
            flattened.addValue(key, values.get(key));
        }
    }
}
