package com.xebialabs.deployit.repository;

@SuppressWarnings("serial")
public class FlattenedEntity extends RepositoryObjectEntity {

	private boolean isFlattenedWithArchetypeAsBase;

    private String archetypeId;

    public FlattenedEntity(RepositoryObjectEntity entity) {
        super(entity.getConfigurationItemTypeName());
        setId(entity.getId());
        setCreatingTaskId(entity.getCreatingTaskId());
        setLastModified(entity.getLastModified());
        archetypeId = entity.getConfigurationItemArchetype() != null ? entity.getConfigurationItemArchetype().getId() : null;
        isFlattenedWithArchetypeAsBase = entity.isArchetype();
    }

    @Override
    public ArchetypeEntity getConfigurationItemArchetype() {
        throw new UnsupportedOperationException("Flattened CIs do not have an archetype");
    }

    @Override
    public boolean isArchetype() {
        return isFlattenedWithArchetypeAsBase;
    }

    public String getArchetypeId() {
        return archetypeId;
    }
}
