package com.xebialabs.deployit.jetty;

import java.util.Collections;
import java.util.Enumeration;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.collect.Lists;

public class HttpHeaderOverrideServletRequest extends HttpServletRequestWrapper {

	private static final String DEFAULT_ACCEPT_HEADER = "Accept";

	public static final String DEFAULT_QUERY_PARAM = "acceptHeader";

	private final String headerOverrideQueryParam;
	
	public HttpHeaderOverrideServletRequest(HttpServletRequest request, String queryParam) {
		super(request);
		this.headerOverrideQueryParam = queryParam;
	}
	
	@Override
	public String getHeader(String name) {
		if(shouldOverrideAcceptHeader(name)){
			String acceptHeaderValue = super.getParameter(headerOverrideQueryParam);
			logger.debug("Overriding Header {} to {} in HttpHeaderOverrideServletRequest", name, acceptHeaderValue);
			return acceptHeaderValue;
		}
		return super.getHeader(name);
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public Enumeration<String> getHeaders(String name) {
		if(shouldOverrideAcceptHeader(name)){
			String acceptHeaderValue = super.getParameter(headerOverrideQueryParam);
			return  Collections.enumeration(Lists.newArrayList(acceptHeaderValue));
		}
		return super.getHeaders(name);
	}
	
	private Boolean shouldOverrideAcceptHeader(String name){
		if(name.equalsIgnoreCase(DEFAULT_ACCEPT_HEADER)){
			String acceptHeaderValue = super.getParameter(headerOverrideQueryParam);
			if(StringUtils.isNotEmpty(acceptHeaderValue)) {
				return  true;
			}
		}
		return false;
	}
	
	private static Logger logger = LoggerFactory.getLogger(HttpHeaderOverrideServletRequest.class);

}
