package com.xebialabs.deployit.jcr;

import com.xebialabs.deployit.repository.ArchetypeEntity;
import com.xebialabs.deployit.repository.ArtifactEntity;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import com.xebialabs.deployit.task.Task;

/**
 * 
 */
public interface JcrConstants {

	/**
	 * Username that represents the anonymous user.
	 */
	public static final String ANONYMOUS_USERNAME = "anonymous";

	/**
	 * Default username for administrative user in Jackrabbit
	 */
	public static final String ADMIN_USERNAME = "admin";

	/**
	 * Default password for administrative user in Jackrabbit
	 */
	public static final String ADMIN_PASSWORD = "admin";

	/**
	 * JCR namespace prefix for Deployit specific types and properties
	 */
	public static final String DEPLOYIT_NAMESPACE_PREFIX = "deployit";

	/**
	 * JCR namespace URI for Deployit specific types and properties
	 */
	public static final String DEPLOYIT_NAMESPACE_URI = "http://www.xebialabs.com/deployit";

	/**
	 * Prefix for JCR property names that are used to store Deployit metadata.
	 */
	public static final String METADATA_PROPERTY_NAME_PREFIX = "$";

	/**
	 * JCR node type name for {@link ConfigurationItemEntity configuration items}.
	 */
	public static final String CONFIGURATION_ITEM_NODETYPE_NAME = DEPLOYIT_NAMESPACE_PREFIX + ":configurationItem";

	/**
	 * JCR node type name for {@link ArtifactEntity artifacts}.
	 */
	public static final String ARTIFACT_NODETYPE_NAME = DEPLOYIT_NAMESPACE_PREFIX + ":artifact";

	/**
	 * JCR node type name for {@link ArchetypeEntity archetypes}.
	 */
	public static final String ARCHETYPE_NODETYPE_NAME = DEPLOYIT_NAMESPACE_PREFIX + ":archetype";

    /**
     * Name of the JCR node under which archetypes are stored.
     */
    public static final String ARCHETYPE_ROOT_NODE_NAME = "Archetypes";    

	/**
	 * Name of property used to store the {@link RepositoryObjectEntity#getId() repository entity id}.
	 */
	public static final String ID_PROPERTY_NAME = METADATA_PROPERTY_NAME_PREFIX + "id";

	/**
	 * Name of property used to store the {@link RepositoryObjectEntity#getLastModified() last modification date}.
	 */
	public static final String LAST_MODIFIED_DATE_PROPERTY_NAME = METADATA_PROPERTY_NAME_PREFIX + "lastModified";

	/**
	 * Name of property used to store the {@link RepositoryObjectEntity#getCreatingTaskId}
	 */
	public static final String CREATING_TASK_ID_PROPERTY_NAME = METADATA_PROPERTY_NAME_PREFIX + "creatingTaskId";

	/**
	 * Name of property used to store the {@link RepositoryObjectEntity#getConfigurationItemArchetype() archetype reference}
	 */
	public static final String ARCHETYPE_PROPERTY_NAME = METADATA_PROPERTY_NAME_PREFIX + "archetype";

	/**
	 * Name of property used to store the {@link ConfigurationItemEntity#getConfigurationItemTypeName() configuration item type name}
	 */
	public static final String CONFIGURATION_ITEM_TYPE_PROPERTY_NAME = METADATA_PROPERTY_NAME_PREFIX + "configuration.item.type";

	/**
	 * Name of property used to store the {@link ArtifactEntity#getData() artifact data}.
	 */
	public static final String DATA_PROPERTY_NAME = METADATA_PROPERTY_NAME_PREFIX + "data";

	/**
	 * JCR node type name for {@link Task tasks}.
	 */
	public static final String TASK_NODETYPE_NAME = DEPLOYIT_NAMESPACE_PREFIX + ":task";

	/**
	 * Name of JCR node under which tasks are stored.
	 */
	public static final String TASKS_NODE_NAME = "tasks";

	/**
	 * Full path of JCR node under which tasks are stored.
	 */
	public static final String TASKS_NODE_ID = "/" + TASKS_NODE_NAME;

	/**
	 * JCR node type name for {@link com.xebialabs.deployit.task.TaskStep steps}.
	 */
	public static final String STEP_NODETYPE_NAME = DEPLOYIT_NAMESPACE_PREFIX + ":step";

	/**
	 * Prefix used for the name of nodes that store steps.
	 */
	public static final String STEP_NODE_NAME_PREFIX = "step";

	/**
	 * JCR node type name used to store the configuration
	 */
	public static final String CONFIGURATION_NODETYPE_NAME = DEPLOYIT_NAMESPACE_PREFIX + ":configuration";

	/**
	 * Name of JCR node used to store the configuration
	 */
	public static final String CONFIGURATION_NODE_NAME = "$configuration";

	/**
	 * Full path of JCR node used to store the configuration
	 */
	public static final String CONFIGURATION_NODE_ID = "/" + CONFIGURATION_NODE_NAME;

	/**
	 * Prefix of name of properties used to store permission in the configuration node
	 */
	public static final String PERMISSION_PROPERTY_NAME_PREFIX = "permission-to-";

}
